/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xslt.run.rt;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.intellij.plugins.xslt.run.rt.XSLTMain;
import org.xml.sax.SAXParseException;

public class XSLTRunner
implements XSLTMain {
    private XSLTRunner() {
    }

    public static void main(String[] args) throws Throwable {
        TransformerFactory transformerFactory;
        XSLTMain main = XSLTRunner.loadMain();
        try {
            transformerFactory = main.createTransformerFactory();
        }
        catch (AbstractMethodError e) {
            transformerFactory = XSLTRunner.createTransformerFactoryStatic();
        }
        catch (ClassNotFoundException e) {
            transformerFactory = XSLTRunner.createTransformerFactoryStatic();
        }
        String uriResolverClass = System.getProperty("xslt.uri-resolver");
        if (uriResolverClass != null) {
            transformerFactory.setURIResolver((URIResolver)Class.forName(uriResolverClass).newInstance());
        }
        boolean[] trouble = new boolean[]{false};
        MyErrorListener listener = new MyErrorListener(trouble);
        boolean isSmartErrorHandling = System.getProperty("xslt.smart-error-handling", "false").equals("true");
        if (isSmartErrorHandling) {
            transformerFactory.setErrorListener(listener);
        }
        File xslt = new File(System.getProperty("xslt.file"));
        try {
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(xslt));
            if (transformer != null && !trouble[0]) {
                StreamResult result;
                BufferedOutputStream fileStream;
                Enumeration<Object> props = System.getProperties().keys();
                while (props.hasMoreElements()) {
                    String s = (String)props.nextElement();
                    if (!s.startsWith("xslt.param.")) continue;
                    String name = s.substring("xslt.param.".length());
                    String value = System.getProperty(s);
                    transformer.setParameter(name, value);
                }
                File input = new File(System.getProperty("xslt.input"));
                String out = System.getProperty("xslt.output");
                if (out != null) {
                    File output = new File(out);
                    fileStream = new BufferedOutputStream(new FileOutputStream(output));
                } else {
                    fileStream = null;
                }
                Integer _port = Integer.getInteger("xslt.listen-port", -1);
                int port = _port;
                if (port != -1) {
                    try {
                        ServerSocket serverSocket = new ServerSocket(port, 1, InetAddress.getByName("127.0.0.1"));
                        serverSocket.setSoTimeout(Integer.getInteger("xslt.listen-timeout", 5000));
                        Socket socket = serverSocket.accept();
                        BufferedOutputStream socketStream = new BufferedOutputStream(socket.getOutputStream(), 16);
                        if (out != null) {
                            result = new StreamResult(new ForkedOutputStream(new OutputStream[]{socketStream, fileStream}));
                        }
                        result = new StreamResult(new OutputStreamWriter((OutputStream)socketStream, "UTF-8"));
                    }
                    catch (SocketTimeoutException ignored) {
                        System.err.println("Plugin did not connect to runner within timeout. Run aborted.");
                        return;
                    }
                } else {
                    String encoding = System.getProperty("file.encoding");
                    if (encoding != null) {
                        transformer.setOutputProperty("encoding", encoding);
                        result = out != null ? new StreamResult(new OutputStreamWriter((OutputStream)new ForkedOutputStream(new OutputStream[]{System.out, fileStream}), encoding)) : new StreamResult(new OutputStreamWriter((OutputStream)System.out, encoding));
                    } else {
                        result = out != null ? new StreamResult(new ForkedOutputStream(new OutputStream[]{System.out, fileStream})) : new StreamResult(System.out);
                    }
                }
                Runtime.getRuntime().addShutdownHook(new Thread("XSLT runner"){

                    public void run() {
                        try {
                            Writer out = result.getWriter();
                            if (out != null) {
                                out.flush();
                                out.close();
                            } else if (result.getOutputStream() != null) {
                                result.getOutputStream().flush();
                                result.getOutputStream().close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                main.start(transformer, new StreamSource(input), result);
            }
        }
        catch (TransformerException e) {
            if (isSmartErrorHandling) {
                listener.error(e);
            }
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public TransformerFactory createTransformerFactory() throws Exception {
        return XSLTRunner.createTransformerFactoryStatic();
    }

    public static TransformerFactory createTransformerFactoryStatic() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String factoryClass = System.getProperty("xslt.transformer-factory");
        if (factoryClass != null) {
            return (TransformerFactory)Class.forName(factoryClass).newInstance();
        }
        return TransformerFactory.newInstance();
    }

    public void start(Transformer transformer, Source source, Result result) throws TransformerException {
        transformer.transform(source, result);
    }

    private static XSLTMain loadMain() {
        String mainClass = System.getProperty("xslt.main");
        if (mainClass == null) {
            return new XSLTRunner();
        }
        try {
            return (XSLTMain)Class.forName(mainClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static class ForkedOutputStream
    extends OutputStream {
        OutputStream[] outs;

        ForkedOutputStream(OutputStream[] out) {
            this.outs = out;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            int outsLength = this.outs.length;
            for (int i = 0; i < outsLength; ++i) {
                this.outs[i].write(b, off, len);
            }
        }

        public void write(int b) throws IOException {
            int outsLength = this.outs.length;
            for (int i = 0; i < outsLength; ++i) {
                this.outs[i].write(b);
            }
        }

        public void flush() throws IOException {
            int outsLength = this.outs.length;
            for (int i = 0; i < outsLength; ++i) {
                this.outs[i].flush();
            }
        }

        public void close() throws IOException {
            int outsLength = this.outs.length;
            for (int i = 0; i < outsLength; ++i) {
                this.outs[i].close();
            }
        }
    }

    private static class MyErrorListener
    implements ErrorListener {
        private final Set myMessages = new HashSet();
        private final boolean[] myTrouble;

        public MyErrorListener(boolean[] trouble) {
            this.myTrouble = trouble;
        }

        public void warning(TransformerException exception) {
            this.handleException(exception, "WARNING");
        }

        public void error(TransformerException exception) {
            this.handleException(exception, "ERROR");
            this.myTrouble[0] = true;
        }

        public void fatalError(TransformerException exception) {
            this.handleException(exception, "FATAL");
            this.myTrouble[0] = true;
        }

        private void handleException(TransformerException exception, String type) {
            String message = MyErrorListener.getMessage(exception);
            if (!this.myMessages.contains(message)) {
                System.err.println("[" + type + "]: " + message);
                this.myMessages.add(message);
            }
        }

        private static String getMessage(TransformerException exception) {
            String systemId;
            SourceLocator[] locators = new SourceLocator[]{exception.getLocator()};
            String[] messages = new String[1];
            MyErrorListener.findLocator(exception, locators, messages);
            SourceLocator locator = locators[0];
            if (locator != null && (systemId = locator.getSystemId()) != null) {
                String s = systemId.replaceAll(" ", "%20") + ": ";
                int lineNumber = locator.getLineNumber();
                if (lineNumber != -1) {
                    s = s + "line " + lineNumber + ": ";
                    int columnNumber = locator.getColumnNumber();
                    if (columnNumber != -1) {
                        s = s + "column " + columnNumber + ": ";
                    }
                }
                return s + (messages[0] != null ? messages[0] : exception.getMessage());
            }
            return messages[0] != null ? messages[0] : exception.getMessage();
        }

        private static void findLocator(Throwable exception, SourceLocator[] locators, String[] messages) {
            Throwable t;
            if (exception instanceof TransformerException) {
                t = (TransformerException)exception;
                if (t.getLocator() != null) {
                    messages[0] = t.getMessage();
                    locators[0] = t.getLocator();
                } else if (exception.getCause() != null) {
                    MyErrorListener.findLocator(exception.getCause(), locators, messages);
                }
            } else if (exception instanceof SAXParseException) {
                final SAXParseException sae = (SAXParseException)exception;
                messages[0] = sae.getMessage();
                locators[0] = new SourceLocator(){

                    public int getColumnNumber() {
                        return sae.getColumnNumber();
                    }

                    public int getLineNumber() {
                        return sae.getLineNumber();
                    }

                    public String getPublicId() {
                        return null;
                    }

                    public String getSystemId() {
                        return sae.getSystemId();
                    }
                };
            } else if (exception.getCause() != null) {
                MyErrorListener.findLocator(exception.getCause(), locators, messages);
            }
            try {
                t = (Throwable)exception.getClass().getMethod("getException", new Class[0]).invoke((Object)exception, new Object[0]);
                if (t != exception) {
                    MyErrorListener.findLocator(t, locators, messages);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }
}

