/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.net;

import com.jogamp.common.net.AssetURLStreamHandler;
import com.jogamp.common.net.GenericURLStreamHandlerFactory;
import com.jogamp.common.net.PiggybackURLContext;
import com.jogamp.common.net.Uri;
import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.util.IOUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public abstract class AssetURLContext
implements PiggybackURLContext {
    private static final boolean DEBUG = IOUtil.DEBUG;
    public static final String asset_protocol = "asset";
    public static final String asset_protocol_prefix = "asset:";
    public static final String assets_folder = "assets/";

    public static AssetURLContext create(final ClassLoader classLoader) {
        return new AssetURLContext(){

            @Override
            public ClassLoader getClassLoader() {
                return classLoader;
            }
        };
    }

    public static AssetURLStreamHandler createHandler(ClassLoader classLoader) {
        return new AssetURLStreamHandler(AssetURLContext.create(classLoader));
    }

    public static URL createURL(String string, ClassLoader classLoader) throws MalformedURLException {
        String string2;
        if (string.startsWith(asset_protocol_prefix)) {
            string2 = string;
        } else {
            String string3 = String.valueOf(asset_protocol_prefix);
            String string4 = String.valueOf(string);
            string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        }
        return new URL(null, string2, AssetURLContext.createHandler(classLoader));
    }

    public static URL createURL(String string) throws MalformedURLException {
        String string2;
        if (string.startsWith(asset_protocol_prefix)) {
            string2 = string;
        } else {
            String string3 = String.valueOf(asset_protocol_prefix);
            String string4 = String.valueOf(string);
            string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        }
        return new URL(string2);
    }

    public static URLStreamHandler getRegisteredHandler() {
        GenericURLStreamHandlerFactory genericURLStreamHandlerFactory = GenericURLStreamHandlerFactory.register();
        return null != genericURLStreamHandlerFactory ? genericURLStreamHandlerFactory.getHandler(asset_protocol) : null;
    }

    public static boolean registerHandler(ClassLoader classLoader) {
        GenericURLStreamHandlerFactory genericURLStreamHandlerFactory = GenericURLStreamHandlerFactory.register();
        if (null != genericURLStreamHandlerFactory) {
            genericURLStreamHandlerFactory.setHandler(asset_protocol, AssetURLContext.createHandler(classLoader));
            return true;
        }
        return false;
    }

    public abstract ClassLoader getClassLoader();

    @Override
    public String getImplementedProtocol() {
        return asset_protocol;
    }

    @Override
    public URLConnection resolve(String string) throws IOException {
        return AssetURLContext.resolve(string, this.getClassLoader());
    }

    public static URLConnection resolve(String string, ClassLoader classLoader) throws IOException {
        int n;
        URLConnection uRLConnection;
        URL uRL;
        block17: {
            Object object;
            block16: {
                uRL = null;
                uRLConnection = null;
                n = -1;
                if (DEBUG) {
                    object = string;
                    System.err.println(new StringBuilder(27 + String.valueOf(object).length()).append("AssetURLContext.resolve: <").append((String)object).append(">").toString());
                }
                try {
                    string = IOUtil.cleanPathString(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IOException(uRISyntaxException);
                }
                try {
                    uRL = new URL(string);
                    uRLConnection = AssetURLContext.open(uRL);
                    n = null != uRLConnection ? 1 : -1;
                }
                catch (MalformedURLException malformedURLException) {
                    if (!DEBUG) break block16;
                    String string2 = String.valueOf(malformedURLException.getMessage());
                    System.err.println(string2.length() != 0 ? "FAIL(1): ".concat(string2) : new String("FAIL(1): "));
                }
            }
            if (null == uRLConnection && null != classLoader) {
                object = string;
                while (((String)object).startsWith("/")) {
                    object = ((String)object).substring(1);
                }
                if (AndroidVersion.isAvailable) {
                    Object object2;
                    if (((String)object).startsWith(assets_folder)) {
                        object2 = object;
                    } else {
                        String string3 = String.valueOf(assets_folder);
                        String string4 = String.valueOf(object);
                        object2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
                    }
                    object = object2;
                }
                int n2 = n = null != (uRLConnection = AssetURLContext.open(uRL = classLoader.getResource((String)object))) ? 2 : -1;
            }
            if (null == uRLConnection) {
                try {
                    object = new File(string);
                    if (((File)object).exists()) {
                        uRL = Uri.valueOf((File)object).toURL();
                        uRLConnection = AssetURLContext.open(uRL);
                        n = null != uRLConnection ? 3 : -1;
                    }
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block17;
                    String string5 = String.valueOf(throwable.getMessage());
                    System.err.println(string5.length() != 0 ? "FAIL(3): ".concat(string5) : new String("FAIL(3): "));
                }
            }
        }
        if (DEBUG) {
            int n3 = n;
            String string6 = String.valueOf(uRL);
            String string7 = String.valueOf(uRLConnection);
            String string8 = String.valueOf(null != uRLConnection ? uRLConnection.getURL() : null);
            System.err.println(new StringBuilder(70 + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length()).append("AssetURLContext.resolve: type ").append(n3).append(": url <").append(string6).append(">, conn <").append(string7).append(">, connURL <").append(string8).append(">").toString());
        }
        if (null == uRLConnection) {
            String string9 = string;
            throw new FileNotFoundException(new StringBuilder(53 + String.valueOf(string9).length()).append("Could not look-up: ").append(string9).append(" as URL, w/ ClassLoader or as File").toString());
        }
        return uRLConnection;
    }

    private static URLConnection open(URL uRL) {
        if (null == uRL) {
            return null;
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            return uRLConnection;
        }
        catch (IOException iOException) {
            if (DEBUG) {
                String string = String.valueOf(iOException.getMessage());
                System.err.println(string.length() != 0 ? "FAIL(2): ".concat(string) : new String("FAIL(2): "));
            }
            return null;
        }
    }
}

