/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.runtime;

import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class ProcAddressTable {
    private static final String PROCADDRESS_VAR_PREFIX = "_addressof_";
    private static final int PROCADDRESS_VAR_PREFIX_LEN = "_addressof_".length();
    protected static boolean DEBUG;
    protected static String DEBUG_PREFIX;
    protected static int debugNum;
    private final FunctionAddressResolver resolver;

    public ProcAddressTable() {
        this(new One2OneResolver());
    }

    public ProcAddressTable(FunctionAddressResolver functionAddressResolver) {
        this.resolver = functionAddressResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(DynamicLookupHelper dynamicLookupHelper) throws SecurityException, RuntimeException {
        PrintStream printStream;
        if (null == dynamicLookupHelper) {
            throw new RuntimeException("Passed null DynamicLookupHelper");
        }
        AccessibleObject[] accessibleObjectArray = this.getClass().getDeclaredFields();
        if (DEBUG) {
            printStream = ProcAddressTable.getDebugOutStream();
            String string = String.valueOf(this.getClass().getName());
            int n = accessibleObjectArray.length;
            printStream.println(new StringBuilder(44 + String.valueOf(string).length()).append(string).append(".reset() (w/ ").append(n).append(" prospective fields)").toString());
        } else {
            printStream = null;
        }
        AccessibleObject.setAccessible(accessibleObjectArray, true);
        dynamicLookupHelper.claimAllLinkPermission();
        try {
            for (int i = 0; i < accessibleObjectArray.length; ++i) {
                String string = ((Field)accessibleObjectArray[i]).getName();
                if (!this.isAddressField(string)) continue;
                String string2 = this.fieldToFunctionName(string);
                this.setEntry((Field)accessibleObjectArray[i], string2, dynamicLookupHelper);
            }
        }
        finally {
            dynamicLookupHelper.releaseAllLinkPermission();
        }
        if (DEBUG) {
            printStream.flush();
            if (DEBUG_PREFIX != null) {
                printStream.close();
            }
        }
    }

    public void initEntry(String string, DynamicLookupHelper dynamicLookupHelper) throws SecurityException, IllegalArgumentException {
        Field field = this.fieldForFunction(string);
        field.setAccessible(true);
        this.setEntry(field, string, dynamicLookupHelper);
    }

    private final void setEntry(Field field, String string, DynamicLookupHelper dynamicLookupHelper) throws SecurityException {
        try {
            assert (field.getType() == Long.TYPE);
            long l = this.resolver.resolve(string, dynamicLookupHelper);
            field.setLong(this, l);
            if (DEBUG) {
                String string2 = String.valueOf(field.getName());
                String string3 = String.valueOf(Long.toHexString(l));
                ProcAddressTable.getDebugOutStream().println(new StringBuilder(8 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("  ").append(string2).append(" -> 0x").append(string3).toString());
            }
        }
        catch (Exception exception) {
            String string4 = String.valueOf(field);
            throw new RuntimeException(new StringBuilder(69 + String.valueOf(string).length() + String.valueOf(string4).length()).append("Can not get proc address for method \"").append(string).append("\": Couldn't set value of field \"").append(string4).toString(), exception);
        }
    }

    private final String fieldToFunctionName(String string) {
        return string.substring(PROCADDRESS_VAR_PREFIX_LEN);
    }

    private final Field fieldForFunction(String string) throws IllegalArgumentException {
        try {
            String string2 = String.valueOf(PROCADDRESS_VAR_PREFIX);
            String string3 = String.valueOf(string);
            return this.getClass().getDeclaredField(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            String string4 = String.valueOf(this.getClass().getName());
            throw new IllegalArgumentException(new StringBuilder(34 + String.valueOf(string4).length() + String.valueOf(string).length()).append(string4).append(" has no entry for the function '").append(string).append("'.").toString(), noSuchFieldException);
        }
    }

    private final Field fieldForFunctionInSec(final String string) throws IllegalArgumentException {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    String string3 = String.valueOf(string);
                    Field field = ProcAddressTable.this.getClass().getDeclaredField(string3.length() != 0 ? ProcAddressTable.PROCADDRESS_VAR_PREFIX.concat(string3) : new String(ProcAddressTable.PROCADDRESS_VAR_PREFIX));
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    String string4 = String.valueOf(this.getClass().getName());
                    String string2 = string;
                    throw new IllegalArgumentException(new StringBuilder(34 + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string4).append(" has no entry for the function '").append(string2).append("'.").toString(), noSuchFieldException);
                }
            }
        });
    }

    private final boolean isAddressField(String string) {
        return string.startsWith(PROCADDRESS_VAR_PREFIX);
    }

    private static final PrintStream getDebugOutStream() {
        PrintStream printStream = null;
        if (DEBUG) {
            if (DEBUG_PREFIX != null) {
                try {
                    String string = DEBUG_PREFIX;
                    char c = File.separatorChar;
                    int n = ++debugNum;
                    printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(new StringBuilder(33 + String.valueOf(string).length()).append(string).append(c).append("procaddresstable-").append(n).append(".txt").toString())));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    printStream = System.err;
                }
            } else {
                printStream = System.err;
            }
        }
        return printStream;
    }

    private final Map<String, Long> toMap() {
        TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
        Field[] fieldArray = this.getClass().getFields();
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                String string = fieldArray[i].getName();
                if (!this.isAddressField(string)) continue;
                treeMap.put(this.fieldToFunctionName(string), (Long)fieldArray[i].get(this));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return treeMap;
    }

    public final boolean isFunctionAvailable(String string) {
        try {
            return this.isFunctionAvailableImpl(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    protected boolean isFunctionAvailableImpl(String string) throws IllegalArgumentException {
        Field field = this.fieldForFunctionInSec(string);
        try {
            return 0L != field.getLong(this);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public long getAddressFor(String string) throws SecurityException, IllegalArgumentException {
        SecurityUtil.checkAllLinkPermission();
        Field field = this.fieldForFunctionInSec(string);
        try {
            return field.getLong(this);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public final Set<String> getNullPointerFunctions() {
        Map<String, Long> map = this.toMap();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            long l = entry.getValue();
            if (l != 0L) continue;
            linkedHashSet.add(entry.getKey());
        }
        return linkedHashSet;
    }

    public final String toString() {
        String string = String.valueOf(this.getClass().getName());
        String string2 = String.valueOf(this.toMap());
        return new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).toString();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                boolean bl = DEBUG = System.getProperty("jogamp.debug.ProcAddressHelper") != null;
                if (DEBUG) {
                    DEBUG_PREFIX = System.getProperty("jogamp.debug.ProcAddressHelper.prefix");
                }
                return null;
            }
        });
    }

    private static class One2OneResolver
    implements FunctionAddressResolver {
        private One2OneResolver() {
        }

        @Override
        public long resolve(String string, DynamicLookupHelper dynamicLookupHelper) throws SecurityException {
            return dynamicLookupHelper.dynamicLookupFunction(string);
        }
    }
}

