/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.locks.SingletonInstance;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public class SingletonInstanceFileLock
extends SingletonInstance {
    static final String temp_file_path;
    private final File file;
    private RandomAccessFile randomAccessFile = null;
    private FileLock fileLock = null;

    public static String getCanonicalTempPath() {
        return temp_file_path;
    }

    public static String getCanonicalTempLockFilePath(String string) {
        String string2 = SingletonInstanceFileLock.getCanonicalTempPath();
        String string3 = String.valueOf(File.separator);
        return new StringBuilder(0 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string).length()).append(string2).append(string3).append(string).toString();
    }

    public SingletonInstanceFileLock(long l, String string) {
        super(l);
        this.file = new File(SingletonInstanceFileLock.getCanonicalTempLockFilePath(string));
        this.setupFileCleanup();
    }

    public SingletonInstanceFileLock(long l, File file) {
        super(l);
        this.file = file;
        this.setupFileCleanup();
    }

    @Override
    public final String getName() {
        return this.file.getPath();
    }

    private void setupFileCleanup() {
        this.file.deleteOnExit();
        Runtime.getRuntime().addShutdownHook(new InterruptSource.Thread(){

            @Override
            public void run() {
                if (SingletonInstanceFileLock.this.isLocked()) {
                    String string = SingletonInstanceFileLock.this.infoPrefix();
                    String string2 = SingletonInstanceFileLock.this.getName();
                    System.err.println(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" XXX ").append(string2).append(" - Unlock @ JVM Shutdown").toString());
                }
                SingletonInstanceFileLock.this.unlock();
            }
        });
    }

    @Override
    protected boolean tryLockImpl() {
        try {
            this.randomAccessFile = new RandomAccessFile(this.file, "rw");
            this.fileLock = this.randomAccessFile.getChannel().tryLock();
            if (this.fileLock != null) {
                return true;
            }
        }
        catch (Exception exception) {
            String string = this.infoPrefix();
            String string2 = this.getName();
            System.err.println(new StringBuilder(41 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" III ").append(string2).append(" - Unable to create and/or lock file").toString());
            exception.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean unlockImpl() {
        try {
            if (null != this.fileLock) {
                this.fileLock.release();
                this.fileLock = null;
            }
            if (null != this.randomAccessFile) {
                this.randomAccessFile.close();
                this.randomAccessFile = null;
            }
            if (null != this.file) {
                this.file.delete();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            String string = this.infoPrefix();
            String string2 = this.getName();
            System.err.println(new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" EEE ").append(string2).append(" - Unable to remove lock file").toString());
            exception.printStackTrace();
        }
        finally {
            this.fileLock = null;
            this.randomAccessFile = null;
        }
        return false;
    }

    static {
        String string = null;
        try {
            File file = File.createTempFile("TEST", "tst");
            String string2 = file.getCanonicalPath();
            file.delete();
            string = string2.substring(0, string2.lastIndexOf(File.separator));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        temp_file_path = string;
    }
}

