/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleConsoleFilter;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleConsoleFilterProvider
implements ConsoleFilterProvider {
    @NotNull
    public Filter[] getDefaultFilters(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/execution/GradleConsoleFilterProvider", "getDefaultFilters"));
        }
        Filter[] filterArray = new Filter[]{new GradleConsoleFilter(project), new RegexpFilter(project, "$FILE_PATH$:$LINE$"){
            private CachedValue<Boolean> myIsGradleProject;
            {
                super(arg0, arg1);
                this.myIsGradleProject = new CachedValueImpl(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/execution/GradleConsoleFilterProvider$1", "lambda$$0"));
                    }
                    return CachedValueProvider.Result.create((Object)this.isGradleProject(), (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)project)});
                });
            }

            public Filter.Result applyFilter(String line, int entireLength) {
                if (line == null || !FileUtil.isAbsolutePlatformIndependent((String)line)) {
                    return null;
                }
                if (Boolean.FALSE.equals(this.myIsGradleProject.getValue())) {
                    return null;
                }
                Filter.Result result = super.applyFilter(line, entireLength);
                if (result == null) {
                    return null;
                }
                Pattern pattern = this.getPattern();
                Matcher matcher = pattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)100L));
                if (!matcher.lookingAt()) {
                    return result;
                }
                int lineStart = entireLength - line.length();
                int start = lineStart + matcher.start();
                int end = lineStart + matcher.end();
                return new Filter.Result(start, end, result.getFirstHyperlinkInfo());
            }

            private boolean isGradleProject() {
                return !GradleSettings.getInstance(project).getLinkedProjectsSettings().isEmpty();
            }
        }};
        if (filterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/GradleConsoleFilterProvider", "getDefaultFilters"));
        }
        return filterArray;
    }
}

