/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.service.execution.DefaultExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleExecutionConsoleManager
extends DefaultExternalSystemExecutionConsoleManager {
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/GradleExecutionConsoleManager", "getExternalSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public ExecutionConsole attachExecutionConsole(@NotNull ExternalSystemTask task, @NotNull Project project, @NotNull ExternalSystemRunConfiguration configuration, @NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler processHandler) throws ExecutionException {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/gradle/execution/GradleExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/execution/GradleExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/gradle/execution/GradleExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/gradle/execution/GradleExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/plugins/gradle/execution/GradleExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "org/jetbrains/plugins/gradle/execution/GradleExecutionConsoleManager", "attachExecutionConsole"));
        }
        ConsoleView textConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        textConsole.attachToProcess(processHandler);
        DuplexConsoleView duplexConsoleView = GradleRunnerUtil.attachTaskExecutionView(project, textConsole, true, "gradle.runner.text.console", processHandler, task.getId());
        if (duplexConsoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/GradleExecutionConsoleManager", "attachExecutionConsole"));
        }
        return duplexConsoleView;
    }
}

