/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterSuiteEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeSuiteEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.ConfigurationErrorEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.OnOutputEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.ReportLocationEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventType;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXPPXmlView;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class GradleTestsExecutionConsoleOutputProcessor {
    private static final Logger LOG = Logger.getInstance(GradleTestsExecutionConsoleOutputProcessor.class);

    public static void onOutput(@NotNull GradleTestsExecutionConsole executionConsole, @NotNull String text, @NotNull Key processOutputType) {
        if (executionConsole == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionConsole", "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsoleOutputProcessor", "onOutput"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsoleOutputProcessor", "onOutput"));
        }
        if (processOutputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processOutputType", "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsoleOutputProcessor", "onOutput"));
        }
        StringBuilder consoleBuffer = executionConsole.getBuffer();
        if (StringUtil.endsWith((CharSequence)text, (CharSequence)"<ijLogEol/>\n")) {
            consoleBuffer.append(StringUtil.trimEnd((String)text, (String)"<ijLogEol/>\n")).append('\n');
            return;
        }
        consoleBuffer.append(text);
        String trimmedText = consoleBuffer.toString().trim();
        consoleBuffer.setLength(0);
        if (!StringUtil.startsWith((CharSequence)trimmedText, (CharSequence)"<ijLog>") || !StringUtil.endsWith((CharSequence)trimmedText, (CharSequence)"</ijLog>")) {
            if (text.trim().isEmpty()) {
                return;
            }
            executionConsole.print(text, ConsoleViewContentType.getConsoleViewType((Key)processOutputType));
            return;
        }
        try {
            TestEventXPPXmlView xml = new TestEventXPPXmlView(trimmedText);
            TestEventType eventType = TestEventType.fromValue(xml.getTestEventType());
            AbstractTestEvent testEvent = null;
            switch (eventType) {
                case CONFIGURATION_ERROR: {
                    testEvent = new ConfigurationErrorEvent(executionConsole);
                    break;
                }
                case REPORT_LOCATION: {
                    testEvent = new ReportLocationEvent(executionConsole);
                    break;
                }
                case BEFORE_TEST: {
                    testEvent = new BeforeTestEvent(executionConsole);
                    break;
                }
                case ON_OUTPUT: {
                    testEvent = new OnOutputEvent(executionConsole);
                    break;
                }
                case AFTER_TEST: {
                    testEvent = new AfterTestEvent(executionConsole);
                    break;
                }
                case BEFORE_SUITE: {
                    testEvent = new BeforeSuiteEvent(executionConsole);
                    break;
                }
                case AFTER_SUITE: {
                    testEvent = new AfterSuiteEvent(executionConsole);
                    break;
                }
            }
            if (testEvent != null) {
                testEvent.process(xml);
            }
        }
        catch (TestEventXmlView.XmlParserException e) {
            LOG.error("Gradle test events parser error", (Throwable)e);
        }
    }
}

