/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class TestMethodGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    public TestMethodGradleConfigurationProducer() {
        super((ConfigurationType)GradleExternalTaskConfigurationType.getInstance());
    }

    @Override
    protected boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        PsiMethod psiMethod = this.getPsiMethodForLocation(contextLocation);
        if (psiMethod == null) {
            return false;
        }
        sourceElement.set((Object)psiMethod);
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (context.getModule() == null) {
            return false;
        }
        if (!this.applyTestMethodConfiguration(configuration, context, psiMethod, containingClass)) {
            return false;
        }
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, contextLocation);
        return true;
    }

    @Nullable
    protected PsiMethod getPsiMethodForLocation(Location contextLocation) {
        Location<PsiMethod> location = GradleRunnerUtil.getMethodLocation(contextLocation);
        return location != null ? (PsiMethod)location.getPsiElement() : null;
    }

    @Override
    protected boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        PsiMethod psiMethod = this.getPsiMethodForLocation(contextLocation);
        if (psiMethod == null) {
            return false;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        String projectPath = this.resolveProjectPath(module);
        if (projectPath == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)projectPath, (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        if (!configuration.getSettings().getTaskNames().containsAll(TestMethodGradleConfigurationProducer.getTasksToRun(module))) {
            return false;
        }
        String scriptParameters = configuration.getSettings().getScriptParameters() + ' ';
        String testFilter = TestMethodGradleConfigurationProducer.createTestFilter(containingClass, psiMethod);
        return scriptParameters.contains(testFilter);
    }

    public void onFirstRun(final ConfigurationFromContext fromContext, ConfigurationContext context, @NotNull Runnable performRunnable) {
        PsiClass containingClass;
        if (performRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "performRunnable", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "onFirstRun"));
        }
        final PsiMethod psiMethod = (PsiMethod)fromContext.getSourceElement();
        InheritorChooser inheritorChooser = new InheritorChooser(){

            protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.system.id"), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
                    return;
                }
                ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
                if (!TestMethodGradleConfigurationProducer.this.applyTestMethodConfiguration(configuration, context, psiMethod, (PsiClass[])ArrayUtil.toObjectArray(classes, PsiClass.class))) {
                    return;
                }
                super.runForClasses(classes, method, context, performRunnable);
            }

            protected void runForClass(PsiClass aClass, PsiMethod psiMethod2, ConfigurationContext context, Runnable performRunnable) {
                if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.system.id"), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
                    return;
                }
                ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
                if (!TestMethodGradleConfigurationProducer.this.applyTestMethodConfiguration(configuration, context, psiMethod2, new PsiClass[]{aClass})) {
                    return;
                }
                super.runForClass(aClass, psiMethod2, context, performRunnable);
            }
        };
        if (inheritorChooser.runMethodInAbstractClass(context, performRunnable, psiMethod, containingClass = psiMethod.getContainingClass())) {
            return;
        }
        super.onFirstRun(fromContext, context, performRunnable);
    }

    private boolean applyTestMethodConfiguration(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull PsiMethod psiMethod, PsiClass ... containingClasses) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "applyTestMethodConfiguration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "applyTestMethodConfiguration"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "applyTestMethodConfiguration"));
        }
        if (containingClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClasses", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "applyTestMethodConfiguration"));
        }
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        String projectPath = this.resolveProjectPath(module);
        if (projectPath == null) {
            return false;
        }
        List<String> tasksToRun = TestMethodGradleConfigurationProducer.getTasksToRun(module);
        if (tasksToRun.isEmpty()) {
            return false;
        }
        configuration.getSettings().setExternalProjectPath(projectPath);
        configuration.getSettings().setTaskNames(tasksToRun);
        StringBuilder buf = new StringBuilder();
        for (PsiClass aClass : containingClasses) {
            String filter = TestMethodGradleConfigurationProducer.createTestFilter(aClass, psiMethod);
            if (filter == null) continue;
            buf.append(filter);
        }
        configuration.getSettings().setScriptParameters(buf.toString().trim());
        configuration.setName((containingClasses.length == 1 ? containingClasses[0].getName() + "." : "") + psiMethod.getName());
        return true;
    }

    @Nullable
    private static String createTestFilter(@NotNull PsiClass aClass, @NotNull PsiMethod psiMethod) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "createTestFilter"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "createTestFilter"));
        }
        return TestMethodGradleConfigurationProducer.createTestFilter(aClass.getQualifiedName(), psiMethod.getName());
    }

    @Nullable
    public static String createTestFilter(@Nullable String aClass, @Nullable String method) {
        if (aClass == null) {
            return null;
        }
        String testFilterPattern = aClass + (method == null ? "" : '.' + method);
        return String.format("--tests \"%s\" ", StringUtil.replaceChar((String)testFilterPattern, (char)'\"', (char)'*'));
    }
}

