/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class BeforeSuiteEvent
extends AbstractTestEvent {
    public BeforeSuiteEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        if (eventXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventXml", "org/jetbrains/plugins/gradle/execution/test/runner/events/BeforeSuiteEvent", "process"));
        }
        String testId = eventXml.getTestId();
        String parentTestId = eventXml.getTestParentId();
        String name = eventXml.getTestName();
        String fqClassName = eventXml.getTestClassName();
        if (StringUtil.isEmpty((String)parentTestId)) {
            this.registerTestProxy(testId, (SMTestProxy)this.getResultsViewer().getTestsRootNode());
        } else {
            String locationUrl = this.findLocationUrl(null, fqClassName);
            GradleSMTestProxy testProxy = new GradleSMTestProxy(name, true, locationUrl, null);
            testProxy.setLocator(this.getExecutionConsole().getUrlProvider());
            testProxy.setParentId(parentTestId);
            testProxy.setStarted();
            this.registerTestProxy(testId, testProxy);
        }
    }
}

