/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectImportErrorHandler {
    public static final String OPEN_GRADLE_SETTINGS = "Please fix the project's Gradle settings.";
    public static final String SET_UP_HTTP_PROXY = "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
    public static final String UNEXPECTED_ERROR_FILE_BUG = "This is an unexpected error. Please file a bug containing the idea.log file.";
    public static final String FIX_GRADLE_VERSION = "Please point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
    public static final Pattern UNSUPPORTED_GRADLE_VERSION_ERROR_PATTERN = Pattern.compile("Gradle version .* is required.*");
    public static final Pattern MISSING_METHOD_PATTERN = Pattern.compile("org.gradle.api.internal.MissingMethodException: Could not find method (.*?) .*");
    public static final Pattern ERROR_LOCATION_PATTERN = Pattern.compile("Build file '(.*)' line: ([\\d]+)");
    private static final Pattern ERROR_IN_FILE_PATTERN = Pattern.compile("Build file '(.*)'");
    public static final String EMPTY_LINE = "\n\n";

    @Nullable
    public abstract ExternalSystemException getUserFriendlyError(@NotNull Throwable var1, @NotNull String var2, @Nullable String var3);

    @NotNull
    public Pair<Throwable, String> getRootCauseAndLocation(@NotNull Throwable error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "getRootCauseAndLocation"));
        }
        Throwable rootCause = error;
        String location = null;
        while (true) {
            Throwable cause;
            if (location == null) {
                location = this.getLocationFrom(rootCause);
            }
            if ((cause = rootCause.getCause()) == null || cause.getMessage() == null && !(cause instanceof StackOverflowError)) break;
            rootCause = cause;
        }
        Pair pair = Pair.create((Object)rootCause, (Object)location);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "getRootCauseAndLocation"));
        }
        return pair;
    }

    @Nullable
    public String getLocationFrom(@NotNull Throwable error) {
        String location;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "getLocationFrom"));
        }
        String errorToString = error.toString();
        if (errorToString.contains("LocationAwareException") && (location = error.getMessage()) != null && location.startsWith("Build file '")) {
            String[] lines = StringUtil.splitByLines((String)location);
            return lines.length > 0 ? lines[0] : null;
        }
        return null;
    }

    @NotNull
    public ExternalSystemException createUserFriendlyError(@NotNull String msg, @Nullable String location, String ... quickFixes) {
        Pair<String, Integer> pair;
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "createUserFriendlyError"));
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "createUserFriendlyError"));
        }
        String newMsg = msg;
        if (!newMsg.isEmpty() && Character.isLowerCase(newMsg.charAt(0))) {
            newMsg = "Cause: " + newMsg;
        }
        if (!StringUtil.isEmpty((String)location) && (pair = AbstractProjectImportErrorHandler.getErrorLocation(location)) != null) {
            LocationAwareExternalSystemException locationAwareExternalSystemException = new LocationAwareExternalSystemException(newMsg, (String)pair.first, (Integer)pair.getSecond(), quickFixes);
            if (locationAwareExternalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "createUserFriendlyError"));
            }
            return locationAwareExternalSystemException;
        }
        ExternalSystemException externalSystemException = new ExternalSystemException(newMsg, null, quickFixes);
        if (externalSystemException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "createUserFriendlyError"));
        }
        return externalSystemException;
    }

    @Nullable
    private static Pair<String, Integer> getErrorLocation(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "getErrorLocation"));
        }
        Matcher matcher = ERROR_LOCATION_PATTERN.matcher(location);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            int line = -1;
            try {
                line = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Pair.create((Object)filePath, (Object)line);
        }
        matcher = ERROR_IN_FILE_PATTERN.matcher(location);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            return Pair.create((Object)filePath, (Object)-1);
        }
        return null;
    }

    @Nullable
    public String parseMissingMethod(@NotNull String rootCauseText) {
        if (rootCauseText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCauseText", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "parseMissingMethod"));
        }
        Matcher matcher = MISSING_METHOD_PATTERN.matcher(rootCauseText);
        return matcher.find() ? matcher.group(1) : null;
    }
}

