/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class LeakDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("StaticFieldLeak", "Static Field Leaks", "A static field will leak contexts.", Category.PERFORMANCE, 6, Severity.WARNING, new Implementation(LeakDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Collections.singletonList(PsiField.class);
    }

    @Override
    @Nullable
    public UastVisitor createUastVisitor(@NonNull JavaContext context) {
        return new FieldChecker(context);
    }

    private static boolean isLeakCandidate(@NonNull PsiClass cls) {
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)false, (String)"android.content.Context") || InheritanceUtil.isInheritor((PsiClass)cls, (boolean)false, (String)"android.view.View") || InheritanceUtil.isInheritor((PsiClass)cls, (boolean)false, (String)"android.app.Fragment");
    }

    private static class FieldChecker
    extends AbstractUastVisitor {
        private final JavaContext mContext;

        private FieldChecker(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitClass(@NotNull UClass node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/LeakDetector$FieldChecker", "visitClass"));
            }
            return super.visitClass(node);
        }

        public boolean visitVariable(UVariable node) {
            if (node instanceof UField) {
                this.checkField((UField)node);
            }
            return super.visitVariable(node);
        }

        private void checkField(UField field) {
            block6: {
                PsiClass cls;
                String fqn;
                block5: {
                    PsiModifierList modifierList = field.getModifierList();
                    if (modifierList == null || !modifierList.hasModifierProperty("static")) {
                        return;
                    }
                    PsiType type2 = field.getType();
                    if (!(type2 instanceof PsiClassType)) {
                        return;
                    }
                    fqn = type2.getCanonicalText();
                    if (fqn.startsWith("java.")) {
                        return;
                    }
                    cls = ((PsiClassType)type2).resolve();
                    if (cls == null) {
                        return;
                    }
                    if (!fqn.startsWith("android.")) break block5;
                    if (!LeakDetector.isLeakCandidate(cls)) break block6;
                    String message = "Do not place Android context classes in static fields; this is a memory leak (and also breaks Instant Run)";
                    this.report((UElement)field, message);
                    break block6;
                }
                int count = 0;
                for (PsiField referenced : cls.getAllFields()) {
                    PsiClass innerCls;
                    if (count++ == 20) break;
                    PsiType innerType = referenced.getType();
                    if (!(innerType instanceof PsiClassType) || (fqn = innerType.getCanonicalText()).startsWith("java.") || (innerCls = ((PsiClassType)innerType).resolve()) == null || !fqn.startsWith("android.") || !LeakDetector.isLeakCandidate(innerCls)) continue;
                    String message = "Do not place Android context classes in static fields (static reference to `" + cls.getName() + "` which has field `" + referenced.getName() + "` pointing to `" + innerCls.getName() + "`); this is a memory leak (and also breaks Instant Run)";
                    this.report((UElement)field, message);
                    break;
                }
            }
        }

        private void report(@NonNull UElement element, @NonNull String message) {
            this.mContext.report(ISSUE, element, this.mContext.getUastLocation(element), message);
        }
    }
}

