/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.UastVisitor;

public class SslCertificateSocketFactoryDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION_JAVA = new Implementation(SslCertificateSocketFactoryDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue CREATE_SOCKET = Issue.create("SSLCertificateSocketFactoryCreateSocket", "Insecure call to `SSLCertificateSocketFactory.createSocket()`", "When `SSLCertificateSocketFactory.createSocket()` is called with an `InetAddress` as the first parameter, TLS/SSL hostname verification is not performed, which could result in insecure network traffic caused by trusting arbitrary hostnames in TLS/SSL certificates presented by peers. In this case, developers must ensure that the `InetAddress` is explicitly verified against the certificate through other means, such as by calling `SSLCertificateSocketFactory.getDefaultHostnameVerifier() to get a `HostnameVerifier` and calling `HostnameVerifier.verify()`.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION_JAVA);
    public static final Issue GET_INSECURE = Issue.create("SSLCertificateSocketFactoryGetInsecure", "Call to `SSLCertificateSocketFactory.getInsecure()`", "The `SSLCertificateSocketFactory.getInsecure()` method returns an SSLSocketFactory with all TLS/SSL security checks disabled, which could result in insecure network traffic caused by trusting arbitrary TLS/SSL certificates presented by peers. This method should be avoided unless needed for a special circumstance such as debugging. Instead, `SSLCertificateSocketFactory.getDefault()` should be used.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION_JAVA);
    private static final String INET_ADDRESS_CLASS = "java.net.InetAddress";
    private static final String SSL_CERTIFICATE_SOCKET_FACTORY_CLASS = "android.net.SSLCertificateSocketFactory";

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("createSocket", "getInsecure");
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression call, @NonNull UMethod method) {
        if (context.getEvaluator().isMemberInSubClassOf((PsiMember)method, SSL_CERTIFICATE_SOCKET_FACTORY_CLASS, false)) {
            String methodName2 = method.getName();
            if ("createSocket".equals(methodName2)) {
                PsiType type2;
                List args = call.getValueArguments();
                if (!args.isEmpty() && (type2 = ((UExpression)args.get(0)).getExpressionType()) != null && (INET_ADDRESS_CLASS.equals(type2.getCanonicalText()) || InheritanceUtil.isInheritor((PsiClass)((PsiClassType)type2).resolve(), (boolean)false, (String)INET_ADDRESS_CLASS))) {
                    context.report(CREATE_SOCKET, (UElement)call, context.getUastLocation((UElement)call), "Use of `SSLCertificateSocketFactory.createSocket()` with an InetAddress parameter can cause insecure network traffic due to trusting arbitrary hostnames in TLS/SSL certificates presented by peers");
                }
            } else if ("getInsecure".equals(methodName2)) {
                context.report(GET_INSECURE, (UElement)call, context.getUastLocation((UElement)call), "Use of `SSLCertificateSocketFactory.getInsecure()` can cause insecure network traffic due to trusting arbitrary TLS/SSL certificates presented by peers");
            }
        }
    }
}

