/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class ViewHolderDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(ViewHolderDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("ViewHolder", "View Holder Candidates", "When implementing a view Adapter, you should avoid unconditionally inflating a new layout; if an available item is passed in for reuse, you should try to use that one instead. This helps make for example ListView scrolling much smoother.", Category.PERFORMANCE, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/training/improving-layouts/smooth-scrolling.html#ViewHolder");
    private static final String GET_VIEW = "getView";
    static final String INFLATE = "inflate";

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UMethod.class);
    }

    @Override
    @Nullable
    public UastVisitor createUastVisitor(@NonNull JavaContext context) {
        return new ViewAdapterVisitor(context);
    }

    private static class InflationVisitor
    extends AbstractUastVisitor {
        private final JavaContext mContext;
        private List<UElement> mNodes;
        private boolean mHaveConditional;

        public InflationVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitCallExpression(UCallExpression node) {
            if (UastExpressionUtils.isMethodCall((UElement)node)) {
                this.checkMethodCall(node);
            }
            return super.visitCallExpression(node);
        }

        private void checkMethodCall(UCallExpression node) {
            String methodName2;
            UExpression receiver2 = node.getReceiver();
            if (receiver2 != null && ViewHolderDetector.INFLATE.equals(methodName2 = node.getMethodName()) && node.getValueArgumentCount() >= 1) {
                boolean insideIf = false;
                if (UastUtils.getParentOfType((UElement)node, (boolean)true, UIfExpression.class, (Class[])new Class[]{USwitchExpression.class}) != null) {
                    insideIf = true;
                    this.mHaveConditional = true;
                }
                if (!insideIf) {
                    if (this.mNodes == null) {
                        this.mNodes = Lists.newArrayList();
                    }
                    this.mNodes.add((UElement)node);
                }
            }
        }

        public void finish() {
            if (!this.mHaveConditional && this.mNodes != null) {
                for (UElement node : this.mNodes) {
                    String message = "Unconditional layout inflation from view adapter: Should use View Holder pattern (use recycled view passed into this method as the second parameter) for smoother scrolling";
                    this.mContext.report(ISSUE, node, this.mContext.getUastLocation(node), message);
                }
            }
        }
    }

    private static class ViewAdapterVisitor
    extends AbstractUastVisitor {
        private final JavaContext mContext;

        public ViewAdapterVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitMethod(UMethod method) {
            if (ViewAdapterVisitor.isViewAdapterMethod(this.mContext, (PsiMethod)method)) {
                InflationVisitor visitor = new InflationVisitor(this.mContext);
                method.accept((UastVisitor)visitor);
                visitor.finish();
            }
            return super.visitMethod(method);
        }

        private static boolean isViewAdapterMethod(JavaContext context, PsiMethod node) {
            JavaEvaluator evaluator = context.getEvaluator();
            return ViewHolderDetector.GET_VIEW.equals(node.getName()) && evaluator.parametersMatch(node, "int", "android.view.View", "android.view.ViewGroup");
        }
    }
}

