/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.client.api;

import com.android.resources.ResourceType;
import com.android.tools.klint.client.api.AndroidReference;
import com.android.tools.klint.client.api.ExternalReferenceExpression;
import com.android.tools.klint.detector.api.ConstantEvaluator;
import com.android.tools.klint.detector.api.JavaContext;
import com.google.common.base.Joiner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaAbstractUExpression;
import org.jetbrains.uast.java.JavaUDeclarationsExpression;
import org.jetbrains.uast.visitor.UastVisitor;

public class UastLintUtils {
    public static String getQualifiedName(PsiElement element) {
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String containingClassFqName = UastLintUtils.getQualifiedName((PsiElement)containingClass);
            if (containingClassFqName == null) {
                return null;
            }
            return containingClassFqName + "." + ((PsiMethod)element).getName();
        }
        if (element instanceof PsiField) {
            PsiClass containingClass = ((PsiField)element).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String containingClassFqName = UastLintUtils.getQualifiedName((PsiElement)containingClass);
            if (containingClassFqName == null) {
                return null;
            }
            return containingClassFqName + "." + ((PsiField)element).getName();
        }
        return null;
    }

    public static PsiElement resolve(ExternalReferenceExpression expression2, UElement context) {
        UDeclaration declaration2 = (UDeclaration)UastUtils.getParentOfType((UElement)context, UDeclaration.class);
        if (declaration2 == null) {
            return null;
        }
        return expression2.resolve((PsiElement)declaration2.getPsi());
    }

    public static String getClassName(PsiClassType type2) {
        PsiClass psiClass = type2.resolve();
        if (psiClass == null) {
            return type2.getClassName();
        }
        return UastLintUtils.getClassName(psiClass);
    }

    public static String getClassName(PsiClass psiClass) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(psiClass.getName());
        for (psiClass = psiClass.getContainingClass(); psiClass != null; psiClass = psiClass.getContainingClass()) {
            stringBuilder.insert(0, psiClass.getName() + ".");
        }
        return stringBuilder.toString();
    }

    public static UExpression findLastAssignment(PsiVariable variable2, UElement call, JavaContext context) {
        UExpression lastAssignment = null;
        if (variable2 instanceof UVariable) {
            variable2 = ((UVariable)variable2).getPsi();
        }
        if (!variable2.hasModifierProperty("final") && (variable2 instanceof PsiLocalVariable || variable2 instanceof PsiParameter)) {
            UMethod containingFunction = UastUtils.getContainingUMethod((UElement)call);
            if (containingFunction != null) {
                ConstantEvaluator.LastAssignmentFinder finder = new ConstantEvaluator.LastAssignmentFinder(variable2, call, context, null, -1);
                containingFunction.accept((UastVisitor)finder);
                lastAssignment = finder.getLastAssignment();
            }
        } else {
            lastAssignment = context.getUastContext().getInitializerBody(variable2);
        }
        if (lastAssignment instanceof UExpression) {
            return lastAssignment;
        }
        return null;
    }

    public static String getReferenceName(UReferenceExpression expression2) {
        UExpression selector2;
        if (expression2 instanceof USimpleNameReferenceExpression) {
            return ((USimpleNameReferenceExpression)expression2).getIdentifier();
        }
        if (expression2 instanceof UQualifiedReferenceExpression && (selector2 = ((UQualifiedReferenceExpression)expression2).getSelector()) instanceof USimpleNameReferenceExpression) {
            return ((USimpleNameReferenceExpression)selector2).getIdentifier();
        }
        return null;
    }

    public static Object findLastValue(PsiVariable variable2, UElement call, JavaContext context, ConstantEvaluator evaluator) {
        Object value2 = null;
        if (!variable2.hasModifierProperty("final") && (variable2 instanceof PsiLocalVariable || variable2 instanceof PsiParameter)) {
            UMethod containingFunction = UastUtils.getContainingUMethod((UElement)call);
            if (containingFunction != null) {
                ConstantEvaluator.LastAssignmentFinder finder = new ConstantEvaluator.LastAssignmentFinder(variable2, call, context, evaluator, 1);
                containingFunction.getUastBody().accept((UastVisitor)finder);
                value2 = finder.getCurrentValue();
            }
        } else {
            UExpression initializer = context.getUastContext().getInitializerBody(variable2);
            if (initializer != null) {
                value2 = initializer.evaluate();
            }
        }
        return value2;
    }

    private static AndroidReference toAndroidReference(UQualifiedReferenceExpression expression2) {
        int i;
        String containingClassFqName;
        List path = UastUtils.asQualifiedPath((UExpression)expression2);
        String packageNameFromResolved = null;
        PsiClass containingClass = UastUtils.getContainingClass((PsiElement)expression2.resolve());
        if (containingClass != null && (containingClassFqName = containingClass.getQualifiedName()) != null && (i = containingClassFqName.lastIndexOf(".R.")) >= 0) {
            packageNameFromResolved = containingClassFqName.substring(0, i);
        }
        if (path == null) {
            return null;
        }
        int size = path.size();
        if (size < 3) {
            return null;
        }
        String r = (String)path.get(size - 3);
        if (!r.equals("R")) {
            return null;
        }
        String packageName = packageNameFromResolved != null ? packageNameFromResolved : Joiner.on((char)'.').join(path.subList(0, size - 3));
        String type2 = (String)path.get(size - 2);
        String name = (String)path.get(size - 1);
        ResourceType resourceType = null;
        for (ResourceType value2 : ResourceType.values()) {
            if (!value2.getName().equals(type2)) continue;
            resourceType = value2;
            break;
        }
        if (resourceType == null) {
            return null;
        }
        return new AndroidReference((UExpression)expression2, packageName, resourceType, name);
    }

    public static AndroidReference toAndroidReferenceViaResolve(UElement element) {
        UExpression node;
        AndroidReference ref;
        UExpression maybeQualified;
        PsiVariable declaration2;
        AndroidReference ref2;
        if (element instanceof UQualifiedReferenceExpression && element instanceof JavaAbstractUExpression && (ref2 = UastLintUtils.toAndroidReference((UQualifiedReferenceExpression)element)) != null) {
            return ref2;
        }
        if (element instanceof UVariable) {
            declaration2 = ((UVariable)element).getPsi();
        } else if (element instanceof UResolvable) {
            declaration2 = ((UResolvable)element).resolve();
        } else {
            return null;
        }
        if (declaration2 == null && element instanceof USimpleNameReferenceExpression && element instanceof JavaAbstractUExpression && (maybeQualified = UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)element))) instanceof UQualifiedReferenceExpression && (ref = UastLintUtils.toAndroidReference((UQualifiedReferenceExpression)maybeQualified)) != null) {
            return ref;
        }
        if (!(declaration2 instanceof PsiVariable)) {
            return null;
        }
        PsiVariable variable2 = declaration2;
        if (!(variable2 instanceof PsiField && variable2.getType() == PsiType.INT && variable2.hasModifierProperty("static") && variable2.hasModifierProperty("final"))) {
            return null;
        }
        PsiClass resTypeClass = ((PsiField)variable2).getContainingClass();
        if (resTypeClass == null || !resTypeClass.hasModifierProperty("static")) {
            return null;
        }
        PsiClass rClass = resTypeClass.getContainingClass();
        if (rClass == null || rClass.getContainingClass() != null || !"R".equals(rClass.getName())) {
            return null;
        }
        String packageName = ((PsiJavaFile)rClass.getContainingFile()).getPackageName();
        if (packageName.isEmpty()) {
            return null;
        }
        String resourceTypeName = resTypeClass.getName();
        ResourceType resourceType = null;
        for (ResourceType value2 : ResourceType.values()) {
            if (!value2.getName().equals(resourceTypeName)) continue;
            resourceType = value2;
            break;
        }
        if (resourceType == null) {
            return null;
        }
        String resourceName = variable2.getName();
        if (element instanceof UExpression) {
            node = (UExpression)element;
        } else if (element instanceof UVariable) {
            node = new JavaUDeclarationsExpression(null, Collections.singletonList((UVariable)element));
        } else {
            throw new IllegalArgumentException("element must be an expression or an UVariable");
        }
        return new AndroidReference(node, packageName, resourceType, resourceName);
    }

    public static boolean areIdentifiersEqual(UExpression first, UExpression second) {
        String firstIdentifier = UastLintUtils.getIdentifier(first);
        String secondIdentifier = UastLintUtils.getIdentifier(second);
        return firstIdentifier != null && secondIdentifier != null && firstIdentifier.equals(secondIdentifier);
    }

    public static String getIdentifier(UExpression expression2) {
        if (expression2 instanceof ULiteralExpression) {
            expression2.asRenderString();
        } else {
            if (expression2 instanceof USimpleNameReferenceExpression) {
                return ((USimpleNameReferenceExpression)expression2).getIdentifier();
            }
            if (expression2 instanceof UQualifiedReferenceExpression) {
                UQualifiedReferenceExpression qualified = (UQualifiedReferenceExpression)expression2;
                String receiverIdentifier = UastLintUtils.getIdentifier(qualified.getReceiver());
                String selectorIdentifier = UastLintUtils.getIdentifier(qualified.getSelector());
                if (receiverIdentifier == null || selectorIdentifier == null) {
                    return null;
                }
                return receiverIdentifier + "." + selectorIdentifier;
            }
        }
        return null;
    }
}

