/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.detector.api;

import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.DefaultPosition;
import com.android.tools.klint.detector.api.Position;
import com.google.common.annotations.Beta;
import java.io.File;

@Beta
public class Location {
    private static final String SUPER_KEYWORD = "super";
    private final File mFile;
    private final Position mStart;
    private final Position mEnd;
    private String mMessage;
    private Location mSecondary;
    private Object mClientData;
    public static final Location NONE = new Location(new File("NONE"), null, null);

    protected Location(File file, Position start, Position end) {
        this.mFile = file;
        this.mStart = start;
        this.mEnd = end;
    }

    public File getFile() {
        return this.mFile;
    }

    public Position getStart() {
        return this.mStart;
    }

    public Position getEnd() {
        return this.mEnd;
    }

    public Location getSecondary() {
        return this.mSecondary;
    }

    public void setSecondary(Location secondary) {
        this.mSecondary = secondary;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setClientData(Object clientData) {
        this.mClientData = clientData;
    }

    public Object getClientData() {
        return this.mClientData;
    }

    public String toString() {
        return "Location [file=" + this.mFile + ", start=" + this.mStart + ", end=" + this.mEnd + ", message=" + this.mMessage + ']';
    }

    public static Location create(File file) {
        return new Location(file, null, null);
    }

    public static Location create(File file, SourcePosition position) {
        if (position.equals((Object)SourcePosition.UNKNOWN)) {
            return new Location(file, null, null);
        }
        return new Location(file, new DefaultPosition(position.getStartLine(), position.getStartColumn(), position.getStartOffset()), new DefaultPosition(position.getEndLine(), position.getEndColumn(), position.getEndOffset()));
    }

    public static Location create(File file, Position start, Position end) {
        return new Location(file, start, end);
    }

    public static Location create(File file, String contents, int startOffset, int endOffset) {
        if (startOffset < 0 || endOffset < startOffset) {
            throw new IllegalArgumentException("Invalid offsets");
        }
        if (contents == null) {
            return new Location(file, new DefaultPosition(-1, -1, startOffset), new DefaultPosition(-1, -1, endOffset));
        }
        int size = contents.length();
        endOffset = Math.min(endOffset, size);
        startOffset = Math.min(startOffset, endOffset);
        DefaultPosition start = null;
        int line = 0;
        int lineOffset = 0;
        char prev = '\u0000';
        for (int offset = 0; offset <= size; ++offset) {
            if (offset == startOffset) {
                start = new DefaultPosition(line, offset - lineOffset, offset);
            }
            if (offset == endOffset) {
                DefaultPosition end = new DefaultPosition(line, offset - lineOffset, offset);
                return new Location(file, start, end);
            }
            char c = contents.charAt(offset);
            if (c == '\n') {
                lineOffset = offset + 1;
                if (prev != '\r') {
                    ++line;
                }
            } else if (c == '\r') {
                ++line;
                lineOffset = offset + 1;
            }
            prev = c;
        }
        return Location.create(file);
    }

    public static Location create(File file, String contents, int line) {
        return Location.create(file, contents, line, null, null, null);
    }

    public static Location create(File file, String contents, int line, String patternStart, String patternEnd, SearchHints hints) {
        int currentLine = 0;
        int offset = 0;
        while (currentLine < line) {
            if ((offset = contents.indexOf(10, offset)) == -1) {
                return Location.create(file);
            }
            ++currentLine;
            ++offset;
        }
        if (line == currentLine) {
            if (patternStart != null) {
                int lineEnd;
                int index;
                SearchDirection direction = SearchDirection.NEAREST;
                if (hints != null) {
                    direction = hints.mDirection;
                }
                if (direction == SearchDirection.BACKWARD) {
                    index = Location.findPreviousMatch(contents, offset, patternStart, hints);
                    line = Location.adjustLine(contents, line, offset, index);
                } else if (direction == SearchDirection.EOL_BACKWARD) {
                    lineEnd = contents.indexOf(10, offset);
                    if (lineEnd == -1) {
                        lineEnd = contents.length();
                    }
                    index = Location.findPreviousMatch(contents, lineEnd, patternStart, hints);
                    line = Location.adjustLine(contents, line, offset, index);
                } else if (direction == SearchDirection.FORWARD) {
                    index = Location.findNextMatch(contents, offset, patternStart, hints);
                    line = Location.adjustLine(contents, line, offset, index);
                } else {
                    assert (direction == SearchDirection.NEAREST || direction == SearchDirection.EOL_NEAREST);
                    lineEnd = contents.indexOf(10, offset);
                    if (lineEnd == -1) {
                        lineEnd = contents.length();
                    }
                    offset = lineEnd;
                    int before = Location.findPreviousMatch(contents, offset, patternStart, hints);
                    int after = Location.findNextMatch(contents, offset, patternStart, hints);
                    if (before == -1) {
                        index = after;
                        line = Location.adjustLine(contents, line, offset, index);
                    } else if (after == -1) {
                        index = before;
                        line = Location.adjustLine(contents, line, offset, index);
                    } else {
                        int newLinesBefore = 0;
                        for (int i = before; i < offset; ++i) {
                            if (contents.charAt(i) != '\n') continue;
                            ++newLinesBefore;
                        }
                        int newLinesAfter = 0;
                        for (int i = offset; i < after; ++i) {
                            if (contents.charAt(i) != '\n') continue;
                            ++newLinesAfter;
                        }
                        if (newLinesBefore < newLinesAfter || newLinesBefore == newLinesAfter && offset - before < after - offset) {
                            index = before;
                            line = Location.adjustLine(contents, line, offset, index);
                        } else {
                            index = after;
                            line = Location.adjustLine(contents, line, offset, index);
                        }
                    }
                }
                if (index != -1) {
                    int lineStart = contents.lastIndexOf(10, index);
                    lineStart = lineStart == -1 ? 0 : ++lineStart;
                    int column = index - lineStart;
                    if (patternEnd != null) {
                        int end = contents.indexOf(patternEnd, offset + patternStart.length());
                        if (end != -1) {
                            return new Location(file, new DefaultPosition(line, column, index), new DefaultPosition(line, -1, end + patternEnd.length()));
                        }
                    } else if (hints != null && (hints.isJavaSymbol() || hints.isWholeWord())) {
                        if (hints.isConstructor() && contents.startsWith(SUPER_KEYWORD, index)) {
                            patternStart = SUPER_KEYWORD;
                        }
                        return new Location(file, new DefaultPosition(line, column, index), new DefaultPosition(line, column + patternStart.length(), index + patternStart.length()));
                    }
                    return new Location(file, new DefaultPosition(line, column, index), new DefaultPosition(line, column, index + patternStart.length()));
                }
            }
            DefaultPosition position = new DefaultPosition(line, -1, offset);
            return new Location(file, position, position);
        }
        return Location.create(file);
    }

    private static int findPreviousMatch(String contents, int offset, String pattern, SearchHints hints) {
        int index;
        while ((index = contents.lastIndexOf(pattern, offset)) != -1) {
            if (Location.isMatch(contents, index, pattern, hints)) {
                return index;
            }
            offset = index - pattern.length();
        }
        return -1;
    }

    private static int findNextMatch(String contents, int offset, String pattern, SearchHints hints) {
        int index;
        int constructorIndex = -1;
        if (hints != null && hints.isConstructor()) {
            assert (hints.isWholeWord());
            index = contents.indexOf(SUPER_KEYWORD, offset);
            if (index != -1 && Location.isMatch(contents, index, SUPER_KEYWORD, hints)) {
                constructorIndex = index;
            }
        }
        while ((index = contents.indexOf(pattern, offset)) != -1) {
            if (Location.isMatch(contents, index, pattern, hints)) {
                if (constructorIndex != -1) {
                    return Math.min(constructorIndex, index);
                }
                return index;
            }
            offset = index + pattern.length();
        }
        return constructorIndex;
    }

    private static boolean isMatch(String contents, int offset, String pattern, SearchHints hints) {
        if (!contents.startsWith(pattern, offset)) {
            return false;
        }
        if (hints != null) {
            char nextChar;
            char prevChar = offset > 0 ? contents.charAt(offset - 1) : (char)'\u0000';
            int lastIndex = offset + pattern.length() - 1;
            char c = nextChar = lastIndex < contents.length() - 1 ? contents.charAt(lastIndex + 1) : (char)'\u0000';
            if (hints.isWholeWord() && (Character.isLetter(prevChar) || Character.isLetter(nextChar))) {
                return false;
            }
            if (hints.isJavaSymbol()) {
                if (Character.isJavaIdentifierPart(prevChar) || Character.isJavaIdentifierPart(nextChar)) {
                    return false;
                }
                if (prevChar == '\"') {
                    return false;
                }
            }
            if (hints.isConstructor() && SUPER_KEYWORD.equals(pattern)) {
                char c2;
                for (int index = lastIndex + 1; index < contents.length() - 1 && (c2 = contents.charAt(index)) != '('; ++index) {
                    if (Character.isWhitespace(c2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static int adjustLine(String doc, int line, int offset, int newOffset) {
        if (newOffset == -1) {
            return line;
        }
        if (newOffset < offset) {
            return line - Location.countLines(doc, newOffset, offset);
        }
        return line + Location.countLines(doc, offset, newOffset);
    }

    private static int countLines(String doc, int start, int end) {
        int lines = 0;
        for (int offset = start; offset < end; ++offset) {
            char c = doc.charAt(offset);
            if (c != '\n') continue;
            ++lines;
        }
        return lines;
    }

    public static Location reverse(Location location) {
        Location next = location.getSecondary();
        location.setSecondary(null);
        while (next != null) {
            Location nextNext = next.getSecondary();
            next.setSecondary(location);
            location = next;
            next = nextNext;
        }
        return location;
    }

    public static class SearchHints {
        private final SearchDirection mDirection;
        private boolean mWholeWord;
        private boolean mJavaSymbol;
        private boolean mConstructor;

        private SearchHints(SearchDirection direction) {
            this.mDirection = direction;
        }

        public static SearchHints create(SearchDirection direction) {
            return new SearchHints(direction);
        }

        public SearchHints matchWholeWord() {
            this.mWholeWord = true;
            return this;
        }

        public boolean isWholeWord() {
            return this.mWholeWord;
        }

        public SearchHints matchJavaSymbol() {
            this.mJavaSymbol = true;
            this.mWholeWord = true;
            return this;
        }

        public boolean isJavaSymbol() {
            return this.mJavaSymbol;
        }

        public SearchHints matchConstructor() {
            this.mConstructor = true;
            this.mWholeWord = true;
            this.mJavaSymbol = true;
            return this;
        }

        public boolean isConstructor() {
            return this.mConstructor;
        }
    }

    public static enum SearchDirection {
        FORWARD,
        BACKWARD,
        EOL_BACKWARD,
        NEAREST,
        EOL_NEAREST;

    }

    public static class ResourceItemHandle
    implements Handle {
        private final ResourceItem mItem;

        public ResourceItemHandle(ResourceItem item) {
            this.mItem = item;
        }

        @Override
        public Location resolve() {
            ResourceFile source = (ResourceFile)this.mItem.getSource();
            assert (source != null) : this.mItem;
            return Location.create(source.getFile());
        }

        @Override
        public void setClientData(Object clientData) {
        }

        @Override
        public Object getClientData() {
            return null;
        }
    }

    public static class DefaultLocationHandle
    implements Handle {
        private final File mFile;
        private final String mContents;
        private final int mStartOffset;
        private final int mEndOffset;
        private Object mClientData;

        public DefaultLocationHandle(Context context, int startOffset, int endOffset) {
            this.mFile = context.file;
            this.mContents = context.getContents();
            this.mStartOffset = startOffset;
            this.mEndOffset = endOffset;
        }

        @Override
        public Location resolve() {
            return Location.create(this.mFile, this.mContents, this.mStartOffset, this.mEndOffset);
        }

        @Override
        public void setClientData(Object clientData) {
            this.mClientData = clientData;
        }

        @Override
        public Object getClientData() {
            return this.mClientData;
        }
    }

    public static interface Handle {
        public Location resolve();

        public void setClientData(Object var1);

        public Object getClientData();
    }
}

