/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.detector.api;

import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;

public final class TextFormat
extends Enum<TextFormat> {
    public static final /* enum */ TextFormat RAW = new TextFormat();
    public static final /* enum */ TextFormat TEXT = new TextFormat();
    public static final /* enum */ TextFormat HTML = new TextFormat();
    public static final /* enum */ TextFormat HTML_WITH_UNICODE = new TextFormat();
    private static final String HTTP_PREFIX = "http://";
    private static final /* synthetic */ TextFormat[] $VALUES;

    public static TextFormat[] values() {
        return (TextFormat[])$VALUES.clone();
    }

    public static TextFormat valueOf(String name) {
        return Enum.valueOf(TextFormat.class, name);
    }

    public String toHtml(String text) {
        return this.convertTo(text, HTML);
    }

    public String toText(String text) {
        return this.convertTo(text, TEXT);
    }

    public String convertTo(String message, TextFormat to) {
        if (this == to) {
            return message;
        }
        switch (this) {
            case RAW: {
                switch (to) {
                    case RAW: {
                        return message;
                    }
                    case TEXT: 
                    case HTML: 
                    case HTML_WITH_UNICODE: {
                        return to.fromRaw(message);
                    }
                }
            }
            case TEXT: {
                switch (to) {
                    case RAW: 
                    case TEXT: {
                        return message;
                    }
                    case HTML: 
                    case HTML_WITH_UNICODE: {
                        return XmlUtils.toXmlTextValue((String)message);
                    }
                }
            }
            case HTML: {
                switch (to) {
                    case HTML: {
                        return message;
                    }
                    case HTML_WITH_UNICODE: {
                        return TextFormat.removeNumericEntities(message);
                    }
                    case RAW: 
                    case TEXT: {
                        return to.fromHtml(message);
                    }
                }
            }
            case HTML_WITH_UNICODE: {
                switch (to) {
                    case HTML: 
                    case HTML_WITH_UNICODE: {
                        return message;
                    }
                    case RAW: 
                    case TEXT: {
                        return to.fromHtml(message);
                    }
                }
            }
        }
        return message;
    }

    private String fromHtml(String html) {
        assert (this == RAW || this == TEXT) : this;
        StringBuilder sb = new StringBuilder(html.length());
        boolean inPre = false;
        int n = html.length();
        for (int i = 0; i < n; ++i) {
            int end;
            char c = html.charAt(i);
            if (c == '<') {
                String tag;
                int begin;
                if (html.startsWith("<!--", i)) {
                    end = html.indexOf("-->", i);
                    if (end == -1) break;
                    i = end + 2;
                    continue;
                }
                boolean isEndTag = false;
                if (html.startsWith("</", i)) {
                    begin = i + 2;
                    isEndTag = true;
                } else {
                    begin = i + 1;
                }
                i = html.indexOf(62, i);
                if (i == -1) break;
                int end2 = i;
                if (html.charAt(i - 1) == '/') {
                    --end2;
                    isEndTag = true;
                }
                if ((tag = html.substring(begin, end2).trim()).equalsIgnoreCase("br")) {
                    sb.append('\n');
                    continue;
                }
                if (!tag.equalsIgnoreCase("p") && !tag.equalsIgnoreCase("div") && !tag.equalsIgnoreCase("pre") && !tag.equalsIgnoreCase("blockquote") && !tag.equalsIgnoreCase("dl") && !tag.equalsIgnoreCase("dd") && !tag.equalsIgnoreCase("dt") && !tag.equalsIgnoreCase("ol") && !tag.equalsIgnoreCase("ul") && !tag.equalsIgnoreCase("li") && (tag.length() != 2 || !tag.startsWith("h") || !Character.isDigit(tag.charAt(1)))) continue;
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '\n') {
                    sb.append('\n');
                }
                if (tag.equals("li") && !isEndTag) {
                    sb.append("* ");
                }
                if (!tag.equalsIgnoreCase("pre")) continue;
                inPre = !isEndTag;
                continue;
            }
            if (c == '&') {
                end = html.indexOf(59, i);
                if (end > i) {
                    String entity = html.substring(i, end + 1);
                    String s = XmlUtils.fromXmlAttributeValue((String)entity);
                    if (s.startsWith("&")) {
                        if (entity.equalsIgnoreCase("&nbsp;")) {
                            s = " ";
                        } else if (entity.startsWith("&#")) {
                            try {
                                int value2 = Integer.parseInt(entity.substring(2));
                                s = Character.toString((char)value2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    sb.append(s);
                    i = end;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (inPre) {
                    sb.append(c);
                    continue;
                }
                if (sb.length() != 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) continue;
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        String s = sb.toString();
        s = SdkUtils.wrap((String)s, (int)60, null);
        return s;
    }

    private String fromRaw(String text) {
        assert (this == HTML || this == HTML_WITH_UNICODE || this == TEXT) : this;
        StringBuilder sb = new StringBuilder(3 * text.length() / 2);
        boolean html = this == HTML || this == HTML_WITH_UNICODE;
        boolean escapeUnicode = this == HTML;
        char prev = '\u0000';
        int flushIndex = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            int end;
            char c = text.charAt(i);
            if ((c == '*' || c == '`') && i < n - 1) {
                if (!(Character.isLetterOrDigit(prev) || Character.isWhitespace(text.charAt(i + 1)) || (end = text.indexOf(c, i + 1)) == -1 || end != n - 1 && Character.isLetter(text.charAt(end + 1)))) {
                    if (i > flushIndex) {
                        TextFormat.appendEscapedText(sb, text, html, flushIndex, i, escapeUnicode);
                    }
                    if (html) {
                        String tag = c == '*' ? "b" : "code";
                        sb.append('<').append(tag).append('>');
                        TextFormat.appendEscapedText(sb, text, html, i + 1, end, escapeUnicode);
                        sb.append('<').append('/').append(tag).append('>');
                    } else {
                        TextFormat.appendEscapedText(sb, text, html, i + 1, end, escapeUnicode);
                    }
                    flushIndex = end + 1;
                    i = flushIndex - 1;
                }
            } else if (html && c == 'h' && i < n - 1 && text.charAt(i + 1) == 't' && text.startsWith(HTTP_PREFIX, i) && !Character.isLetterOrDigit(prev)) {
                char d;
                for (end = i + HTTP_PREFIX.length(); end < n && !Character.isWhitespace(d = text.charAt(end)); ++end) {
                }
                char last = text.charAt(end - 1);
                if (last == '.' || last == ')' || last == '!') {
                    --end;
                }
                if (end > i + HTTP_PREFIX.length()) {
                    if (i > flushIndex) {
                        TextFormat.appendEscapedText(sb, text, html, flushIndex, i, escapeUnicode);
                    }
                    String url = text.substring(i, end);
                    sb.append("<a href=\"");
                    sb.append(url);
                    sb.append('\"').append('>');
                    sb.append(url);
                    sb.append("</a>");
                    flushIndex = end;
                    i = flushIndex - 1;
                }
            }
            prev = c;
        }
        if (flushIndex < n) {
            TextFormat.appendEscapedText(sb, text, html, flushIndex, n, escapeUnicode);
        }
        return sb.toString();
    }

    private static String removeNumericEntities(String html) {
        if (!html.contains("&#")) {
            return html;
        }
        StringBuilder sb = new StringBuilder(html.length());
        int n = html.length();
        for (int i = 0; i < n; ++i) {
            int end;
            char c = html.charAt(i);
            if (c == '&' && i < n - 1 && html.charAt(i + 1) == '#' && (end = html.indexOf(59, i + 2)) != -1) {
                String decimal = html.substring(i + 2, end);
                try {
                    c = (char)Integer.parseInt(decimal);
                    sb.append(c);
                    i = end;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void appendEscapedText(StringBuilder sb, String text, boolean html, int start, int end, boolean escapeUnicode) {
        if (html) {
            for (int i = start; i < end; ++i) {
                char c = text.charAt(i);
                if (c == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c == '&') {
                    sb.append("&amp;");
                    continue;
                }
                if (c == '\n') {
                    sb.append("<br/>\n");
                    continue;
                }
                if (c > '\u00ff' && escapeUnicode) {
                    sb.append("&#");
                    sb.append(Integer.toString(c));
                    sb.append(';');
                    continue;
                }
                if (c == '\u00a0') {
                    sb.append("&nbsp;");
                    continue;
                }
                sb.append(c);
            }
        } else {
            for (int i = start; i < end; ++i) {
                char c = text.charAt(i);
                sb.append(c);
            }
        }
    }

    static {
        $VALUES = new TextFormat[]{RAW, TEXT, HTML, HTML_WITH_UNICODE};
    }
}

