/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.android.tools.klint.client.api.IssueRegistry;
import com.android.tools.klint.client.api.LintDriver;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.TextFormat;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.CustomEditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.klint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.klint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.klint.AndroidLintUtil;
import org.jetbrains.android.inspections.klint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.klint.IntellijLintClient;
import org.jetbrains.android.inspections.klint.IntellijLintIssueRegistry;
import org.jetbrains.android.inspections.klint.IntellijLintProject;
import org.jetbrains.android.inspections.klint.IntellijLintRequest;
import org.jetbrains.android.inspections.klint.ProblemData;
import org.jetbrains.android.inspections.klint.State;
import org.jetbrains.android.inspections.klint.SuppressLintIntentionAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;

public class AndroidLintExternalAnnotator
extends ExternalAnnotator<State, State> {
    static final boolean INCLUDE_IDEA_SUPPRESS_ACTIONS = false;
    static final boolean IS_UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private String myShortcutText;

    @Nullable
    public State collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "collectInformation"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "collectInformation"));
        }
        return this.collectInformation(file);
    }

    public State collectInformation(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "collectInformation"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null && !IntellijLintProject.hasAndroidModule(module.getProject())) {
            return null;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        FileType fileType = file.getFileType();
        if (fileType == FileTypes.PLAIN_TEXT ? !"proguard-project.txt".equals(file.getName()) && !"proguard.cfg".equals(file.getName()) : fileType != KotlinFileType.INSTANCE && fileType != StdFileTypes.PROPERTIES) {
            return null;
        }
        List<Issue> issues = AndroidLintExternalAnnotator.getIssuesFromInspections(file.getProject(), (PsiElement)file);
        if (issues.size() == 0) {
            return null;
        }
        return new State(module, vFile, file.getText(), issues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State doAnnotate(State state) {
        IntellijLintClient client = IntellijLintClient.forEditor(state);
        try {
            EnumSet<Scope> scope;
            final LintDriver lint = new LintDriver(new IntellijLintIssueRegistry(), client);
            VirtualFile mainFile = state.getMainFile();
            FileType fileType = mainFile.getFileType();
            String name = mainFile.getName();
            if (fileType == StdFileTypes.XML) {
                scope = name.equals("AndroidManifest.xml") ? Scope.MANIFEST_SCOPE : Scope.RESOURCE_FILE_SCOPE;
            } else if (fileType == KotlinFileType.INSTANCE) {
                scope = Scope.JAVA_FILE_SCOPE;
            } else if (name.equals("proguard.cfg") || name.equals("proguard-project.txt")) {
                scope = EnumSet.of(Scope.PROGUARD_FILE);
            } else if (fileType == StdFileTypes.PROPERTIES) {
                scope = Scope.PROPERTY_SCOPE;
            } else {
                assert (false);
                State state2 = state;
                return state2;
            }
            Project project = state.getModule().getProject();
            if (project.isDisposed()) {
                State state3 = state;
                return state3;
            }
            List<VirtualFile> files = Collections.singletonList(mainFile);
            final IntellijLintRequest request = new IntellijLintRequest(client, project, files, Collections.singletonList(state.getModule()), true);
            request.setScope(scope);
            if (!IS_UNIT_TEST_MODE) {
                ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        lint.analyze(request);
                    }
                });
            } else {
                lint.analyze(request);
            }
        }
        finally {
            Disposer.dispose((Disposable)client);
        }
        return state;
    }

    @NotNull
    static List<Issue> getIssuesFromInspections(@NotNull Project project, @Nullable PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "getIssuesFromInspections"));
        }
        ArrayList<Issue> result = new ArrayList<Issue>();
        IntellijLintIssueRegistry fullRegistry = new IntellijLintIssueRegistry();
        for (Issue issue : ((IssueRegistry)fullRegistry).getIssues()) {
            HighlightDisplayKey key;
            String inspectionShortName = AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue);
            if (inspectionShortName == null || (key = HighlightDisplayKey.find((String)inspectionShortName)) == null) continue;
            InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
            boolean enabled = context != null ? profile.isToolEnabled(key, context) : profile.isToolEnabled(key);
            if (!enabled) continue;
            if (!issue.isEnabledByDefault()) {
                issue.setEnabledByDefault(true);
            }
            result.add(issue);
        }
        ArrayList<Issue> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "getIssuesFromInspections"));
        }
        return arrayList;
    }

    public void apply(@NotNull PsiFile file, State state, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "apply"));
        }
        if (state.isDirty()) {
            return;
        }
        Project project = file.getProject();
        for (ProblemData problemData : state.getProblems()) {
            Issue original;
            HighlightDisplayLevel configuredLevel;
            HighlightDisplayKey key;
            Pair<AndroidLintInspectionBase, HighlightDisplayLevel> pair;
            Issue issue = problemData.getIssue();
            String message = problemData.getMessage();
            TextRange range = problemData.getTextRange();
            if (range.getStartOffset() == range.getEndOffset() || (pair = AndroidLintUtil.getHighlighLevelAndInspection(project, issue, (PsiElement)file)) == null) continue;
            AndroidLintInspectionBase inspection = (AndroidLintInspectionBase)((Object)pair.getFirst());
            HighlightDisplayLevel displayLevel = (HighlightDisplayLevel)pair.getSecond();
            if (inspection == null || (key = HighlightDisplayKey.find((String)inspection.getShortName())) == null) continue;
            PsiElement startElement = file.findElementAt(range.getStartOffset());
            PsiElement endElement = file.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || inspection.isSuppressedFor(startElement)) continue;
            if (problemData.getConfiguredSeverity() != null && (configuredLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(problemData.getConfiguredSeverity())) != null) {
                displayLevel = configuredLevel;
            }
            Annotation annotation = this.createAnnotation(holder, message, range, displayLevel, issue);
            for (AndroidLintQuickFix androidLintQuickFix : inspection.getQuickFixes(startElement, endElement, message)) {
                if (!androidLintQuickFix.isApplicable(startElement, endElement, AndroidQuickfixContexts.EditorContext.TYPE)) continue;
                annotation.registerFix((IntentionAction)new MyFixingIntention(androidLintQuickFix, startElement, endElement));
            }
            for (AndroidLintQuickFix androidLintQuickFix : inspection.getIntentions(startElement, endElement)) {
                annotation.registerFix((IntentionAction)androidLintQuickFix);
            }
            String id = key.getID();
            if ((IntellijLintIssueRegistry.CUSTOM_ERROR == issue || IntellijLintIssueRegistry.CUSTOM_WARNING == issue) && (original = IntellijLintClient.findCustomIssue(message)) != null) {
                id = original.getId();
            }
            annotation.registerFix((IntentionAction)new SuppressLintIntentionAction(id, startElement));
            annotation.registerFix((IntentionAction)new MyDisableInspectionFix(key));
            annotation.registerFix((IntentionAction)new MyEditInspectionToolsSettingsAction(key, inspection));
        }
    }

    @NotNull
    private Annotation createAnnotation(@NotNull AnnotationHolder holder, @NotNull String message, @NotNull TextRange range, @NotNull HighlightDisplayLevel displayLevel, @NotNull Issue issue) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "createAnnotation"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "createAnnotation"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "createAnnotation"));
        }
        if (displayLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayLevel", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "createAnnotation"));
        }
        if (issue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issue", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "createAnnotation"));
        }
        HighlightSeverity severity = displayLevel == HighlightDisplayLevel.ERROR ? HighlightSeverity.ERROR : (displayLevel == HighlightDisplayLevel.WARNING ? HighlightSeverity.WARNING : (displayLevel == HighlightDisplayLevel.WEAK_WARNING ? HighlightSeverity.WEAK_WARNING : (displayLevel == HighlightDisplayLevel.INFO ? HighlightSeverity.INFO : HighlightSeverity.WARNING)));
        String link = " <a href=\"#lint/" + issue.getId() + "\"" + (UIUtil.isUnderDarcula() ? " color=\"7AB4C9\" " : "") + ">" + DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]) + "</a> " + this.getShowMoreShortCut();
        String tooltip = XmlStringUtil.wrapInHtml((CharSequence)(TextFormat.RAW.convertTo(message, TextFormat.HTML) + link));
        Annotation annotation = holder.createAnnotation(severity, range, message, tooltip);
        if (annotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator", "createAnnotation"));
        }
        return annotation;
    }

    private String getShowMoreShortCut() {
        if (this.myShortcutText == null) {
            Keymap keymap;
            KeymapManager keymapManager = KeymapManager.getInstance();
            this.myShortcutText = keymapManager != null ? ((keymap = keymapManager.getActiveKeymap()) == null ? "" : "(" + KeymapUtil.getShortcutsText((Shortcut[])keymap.getShortcuts("ShowErrorDescription")) + ")") : "";
        }
        return this.myShortcutText;
    }

    private static class MyEditInspectionToolsSettingsAction
    extends CustomEditInspectionToolsSettingsAction {
        private MyEditInspectionToolsSettingsAction(@NotNull HighlightDisplayKey key, final @NotNull AndroidLintInspectionBase inspection) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyEditInspectionToolsSettingsAction", "<init>"));
            }
            if (inspection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspection", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyEditInspectionToolsSettingsAction", "<init>"));
            }
            super(key, (Computable)new Computable<String>(){

                public String compute() {
                    return "Edit '" + inspection.getDisplayName() + "' inspection settings";
                }
            });
        }
    }

    public static class MyFixingIntention
    implements IntentionAction,
    HighPriorityAction {
        private final AndroidLintQuickFix myQuickFix;
        private final PsiElement myStartElement;
        private final PsiElement myEndElement;

        public MyFixingIntention(@NotNull AndroidLintQuickFix quickFix, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (quickFix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFix", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyFixingIntention", "<init>"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyFixingIntention", "<init>"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyFixingIntention", "<init>"));
            }
            this.myQuickFix = quickFix;
            this.myStartElement = startElement;
            this.myEndElement = endElement;
        }

        @NotNull
        public String getText() {
            String string = this.myQuickFix.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyFixingIntention", "getText"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = AndroidBundle.message((String)"android.lint.quickfixes.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyFixingIntention", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyFixingIntention", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyFixingIntention", "invoke"));
            }
            FileModificationService.getInstance().prepareFileForWrite(file);
            this.myQuickFix.apply(this.myStartElement, this.myEndElement, AndroidQuickfixContexts.EditorContext.getInstance(editor));
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    private static class MyDisableInspectionFix
    implements IntentionAction,
    Iconable {
        private final DisableInspectionToolAction myDisableInspectionToolAction;

        private MyDisableInspectionFix(@NotNull HighlightDisplayKey key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyDisableInspectionFix", "<init>"));
            }
            this.myDisableInspectionToolAction = new DisableInspectionToolAction(key);
        }

        @NotNull
        public String getText() {
            if ("Disable inspection" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyDisableInspectionFix", "getText"));
            }
            return "Disable inspection";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyDisableInspectionFix", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyDisableInspectionFix", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/klint/AndroidLintExternalAnnotator$MyDisableInspectionFix", "invoke"));
            }
            this.myDisableInspectionToolAction.invoke(project, editor, file);
        }

        public boolean startInWriteAction() {
            return this.myDisableInspectionToolAction.startInWriteAction();
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return this.myDisableInspectionToolAction.getIcon(flags);
        }
    }
}

