/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.usability.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.usability.plugin.Expression;
import org.apache.maven.usability.plugin.ExpressionDocumentation;
import org.apache.maven.usability.plugin.ExpressionDocumentationException;
import org.apache.maven.usability.plugin.io.xpp3.ParamdocXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ExpressionDocumenter {
    private static final String[] EXPRESSION_ROOTS = new String[]{"project", "settings", "session", "plugin", "rootless"};
    private static final String EXPRESSION_DOCO_ROOTPATH = "META-INF/maven/plugin-expressions/";
    private static Map<String, Expression> expressionDocumentation;

    public static Map<String, Expression> load() throws ExpressionDocumentationException {
        if (expressionDocumentation == null) {
            expressionDocumentation = new HashMap<String, Expression>();
            ClassLoader docLoader = ExpressionDocumenter.initializeDocLoader();
            for (String EXPRESSION_ROOT : EXPRESSION_ROOTS) {
                try (InputStream docStream = docLoader.getResourceAsStream(EXPRESSION_DOCO_ROOTPATH + EXPRESSION_ROOT + ".paramdoc.xml");){
                    if (docStream == null) continue;
                    Map<String, Expression> doco = ExpressionDocumenter.parseExpressionDocumentation(docStream);
                    expressionDocumentation.putAll(doco);
                }
                catch (IOException e) {
                    throw new ExpressionDocumentationException("Failed to read documentation for expression root: " + EXPRESSION_ROOT, e);
                }
                catch (XmlPullParserException e) {
                    throw new ExpressionDocumentationException("Failed to parse documentation for expression root: " + EXPRESSION_ROOT, e);
                }
            }
        }
        return expressionDocumentation;
    }

    private static Map<String, Expression> parseExpressionDocumentation(InputStream docStream) throws IOException, XmlPullParserException {
        BufferedReader reader = new BufferedReader((Reader)ReaderFactory.newXmlReader((InputStream)docStream));
        ParamdocXpp3Reader paramdocReader = new ParamdocXpp3Reader();
        ExpressionDocumentation documentation = paramdocReader.read(reader, true);
        List<Expression> expressions = documentation.getExpressions();
        HashMap<String, Expression> bySyntax = new HashMap<String, Expression>();
        if (expressions != null && !expressions.isEmpty()) {
            for (Expression expression : expressions) {
                bySyntax.put(expression.getSyntax(), expression);
            }
        }
        return bySyntax;
    }

    private static ClassLoader initializeDocLoader() throws ExpressionDocumentationException {
        URL docResource;
        String myResourcePath = ExpressionDocumenter.class.getName().replace('.', '/') + ".class";
        URL myResource = ExpressionDocumenter.class.getClassLoader().getResource(myResourcePath);
        assert (myResource != null) : "The resource is this class itself loaded by its own classloader and must exist";
        String myClasspathEntry = myResource.getPath();
        if ((myClasspathEntry = myClasspathEntry.substring(0, myClasspathEntry.length() - (myResourcePath.length() + 2))).startsWith("file:")) {
            myClasspathEntry = myClasspathEntry.substring("file:".length());
        }
        try {
            docResource = new File(myClasspathEntry).toURL();
        }
        catch (MalformedURLException e) {
            throw new ExpressionDocumentationException("Cannot construct expression documentation classpath resource base.", e);
        }
        return new URLClassLoader(new URL[]{docResource});
    }
}

