/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.jetbrains.jps.javac.ast.JavacReferenceCollectorListener;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacRef;

class JavacTreeRefScanner
extends TreeScanner<Tree, JavacReferenceCollectorListener.ReferenceCollector> {
    private static final Set<ElementKind> ALLOWED_ELEMENTS = EnumSet.of(ElementKind.ENUM, new ElementKind[]{ElementKind.CLASS, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE, ElementKind.ENUM_CONSTANT, ElementKind.FIELD, ElementKind.CONSTRUCTOR, ElementKind.METHOD});

    JavacTreeRefScanner() {
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, JavacReferenceCollectorListener.ReferenceCollector refCollector) {
        this.scan(node.getPackageAnnotations(), refCollector);
        this.scan(node.getTypeDecls(), refCollector);
        return node;
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, JavacReferenceCollectorListener.ReferenceCollector refCollector) {
        Element element = refCollector.getReferencedElement(node);
        if (element == null) {
            return null;
        }
        if (ALLOWED_ELEMENTS.contains((Object)element.getKind())) {
            refCollector.sinkReference(refCollector.asJavacRef(element));
        }
        return null;
    }

    @Override
    public Tree visitVariable(VariableTree node, JavacReferenceCollectorListener.ReferenceCollector refCollector) {
        Element element = refCollector.getReferencedElement(node);
        if (element != null && element.getKind() == ElementKind.FIELD) {
            refCollector.sinkReference(refCollector.asJavacRef(element));
        }
        return (Tree)super.visitVariable(node, refCollector);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, JavacReferenceCollectorListener.ReferenceCollector refCollector) {
        Element element = refCollector.getReferencedElement(node);
        if (element != null && element.getKind() != ElementKind.PACKAGE) {
            refCollector.sinkReference(refCollector.asJavacRef(element));
        }
        return (Tree)super.visitMemberSelect(node, refCollector);
    }

    @Override
    public Tree visitMethod(MethodTree node, JavacReferenceCollectorListener.ReferenceCollector refCollector) {
        Element element = refCollector.getReferencedElement(node);
        if (element != null) {
            refCollector.sinkReference(refCollector.asJavacRef(element));
        }
        return (Tree)super.visitMethod(node, refCollector);
    }

    @Override
    public Tree visitClass(ClassTree node, JavacReferenceCollectorListener.ReferenceCollector refCollector) {
        JavacRef[] supers;
        TypeElement element = (TypeElement)refCollector.getReferencedElement(node);
        if (element == null) {
            return null;
        }
        TypeMirror superclass = element.getSuperclass();
        List<? extends TypeMirror> interfaces = element.getInterfaces();
        if (superclass != refCollector.getTypeUtility().getNoType(TypeKind.NONE)) {
            supers = new JavacRef[interfaces.size() + 1];
            JavacRef.JavacElementRefBase ref = refCollector.asJavacRef(refCollector.getTypeUtility().asElement(superclass));
            if (ref == null) {
                return null;
            }
            supers[interfaces.size()] = ref;
        } else {
            supers = interfaces.isEmpty() ? JavacRef.EMPTY_ARRAY : new JavacRef[interfaces.size()];
        }
        int i = 0;
        for (TypeMirror typeMirror : interfaces) {
            JavacRef.JavacElementRefBase ref = refCollector.asJavacRef(refCollector.getTypeUtility().asElement(typeMirror));
            if (ref == null) {
                return null;
            }
            supers[i++] = ref;
        }
        JavacRef.JavacElementRefBase aClass = refCollector.asJavacRef(element);
        if (aClass == null) {
            return null;
        }
        refCollector.sinkReference(aClass);
        refCollector.sinkDeclaration(new JavacDef.JavacClassDef(aClass, supers));
        return (Tree)super.visitClass(node, refCollector);
    }

    static JavacTreeRefScanner createASTScanner() {
        try {
            Class<?> aClass = Class.forName("org.jetbrains.jps.javac.ast.Javac8RefScanner");
            return (JavacTreeRefScanner)aClass.newInstance();
        }
        catch (Throwable ignored) {
            return new JavacTreeRefScanner();
        }
    }
}

