/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast.api;

import com.intellij.util.containers.SLRUCache;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.jetbrains.annotations.NotNull;

public class JavacNameTable {
    private final SLRUCache<Name, String> myParsedNameCache = new SLRUCache<Name, String>(1000, 1000){

        @NotNull
        public String createValue(Name key) {
            String string = key.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacNameTable$1", "createValue"));
            }
            return string;
        }
    };
    private final Elements myElements;
    private Name myAsterisk;

    public JavacNameTable(Elements elements) {
        this.myElements = elements;
    }

    @NotNull
    public String parseName(Name name) {
        String string = (String)this.myParsedNameCache.get((Object)name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacNameTable", "parseName"));
        }
        return string;
    }

    @NotNull
    public String parseBinaryName(Element element) {
        String string = this.parseName(this.myElements.getBinaryName((TypeElement)element));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacNameTable", "parseBinaryName"));
        }
        return string;
    }

    @NotNull
    public Name getAsterisk() {
        if (this.myAsterisk == null) {
            this.myAsterisk = this.myElements.getName("*");
        }
        Name name = this.myAsterisk;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacNameTable", "getAsterisk"));
        }
        return name;
    }
}

