/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.util.SystemInfoRt;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BundleBase {
    public static final char MNEMONIC = '\u001b';
    public static boolean assertKeyIsFound = false;

    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        String value;
        block6: {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/BundleBase", "messageOrDefault"));
            }
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/BundleBase", "messageOrDefault"));
            }
            if (bundle == null) {
                return defaultValue;
            }
            try {
                value = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (defaultValue != null) {
                    value = defaultValue;
                }
                value = "!" + key + "!";
                if (!assertKeyIsFound || $assertionsDisabled) break block6;
                throw new AssertionError((Object)("'" + key + "' is not found in " + bundle));
            }
        }
        value = BundleBase.replaceMnemonicAmpersand(value);
        return BundleBase.format(value, params);
    }

    @NotNull
    public static String format(@NotNull String value, Object ... params) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/BundleBase", "format"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/BundleBase", "format"));
        }
        if (params.length > 0 && value.indexOf(123) >= 0) {
            String string = MessageFormat.format(value, params);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/BundleBase", "format"));
            }
            return string;
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/BundleBase", "format"));
        }
        return string;
    }

    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "com/intellij/BundleBase", "message"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/BundleBase", "message"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/BundleBase", "message"));
        }
        String string = BundleBase.messageOrDefault(bundle, key, null, params);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/BundleBase", "message"));
        }
        return string;
    }

    public static String replaceMnemonicAmpersand(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (value.indexOf(38) >= 0) {
            boolean useMacMnemonic = value.contains("&&");
            StringBuilder realValue = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\\') {
                    if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                        realValue.append('&');
                        ++i;
                        continue;
                    }
                    realValue.append(c);
                    continue;
                }
                if (c == '&') {
                    if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                        if (SystemInfoRt.isMac) {
                            realValue.append('\u001b');
                        }
                        ++i;
                        continue;
                    }
                    if (SystemInfoRt.isMac && useMacMnemonic) continue;
                    realValue.append('\u001b');
                    continue;
                }
                realValue.append(c);
            }
            return realValue.toString();
        }
        return value;
    }
}

