/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class ProcessIOExecutorService
extends ThreadPoolExecutor {
    public static final String POOLED_THREAD_PREFIX = "Process I/O pool ";
    public static final ExecutorService INSTANCE = new ProcessIOExecutorService();
    private final AtomicInteger counter = new AtomicInteger();

    private ProcessIOExecutorService() {
        super(1, Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
        this.setThreadFactory(new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/execution/process/ProcessIOExecutorService$1", "newThread"));
                }
                Thread thread = new Thread(r, ProcessIOExecutorService.POOLED_THREAD_PREFIX + ProcessIOExecutorService.this.counter.incrementAndGet());
                thread.setPriority(4);
                Thread thread2 = thread;
                if (thread2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessIOExecutorService$1", "newThread"));
                }
                return thread2;
            }
        });
    }

    public int getThreadCounter() {
        return this.counter.get();
    }
}

