/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.Enumerator;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import org.jetbrains.annotations.NotNull;

public class BiDirectionalEnumerator<T>
extends Enumerator<T> {
    @NotNull
    private final TIntObjectHashMap<T> myIntToObjectMap;

    public BiDirectionalEnumerator(int expectNumber, @NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/BiDirectionalEnumerator", "<init>"));
        }
        super(expectNumber, strategy);
        this.myIntToObjectMap = new TIntObjectHashMap(expectNumber);
    }

    @Override
    public int enumerateImpl(T object) {
        int index = super.enumerateImpl(object);
        this.myIntToObjectMap.put(index, object);
        return index;
    }

    @Override
    public void clear() {
        super.clear();
        this.myIntToObjectMap.clear();
    }

    @NotNull
    public T getValue(int index) {
        Object hash = this.myIntToObjectMap.get(index);
        if (hash == null) {
            throw new RuntimeException("Can not find value by index " + index);
        }
        Object object = hash;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/BiDirectionalEnumerator", "getValue"));
        }
        return (T)object;
    }

    public void forEachValue(@NotNull TObjectProcedure<T> procedure) {
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "com/intellij/util/containers/BiDirectionalEnumerator", "forEachValue"));
        }
        this.myIntToObjectMap.forEachValue(procedure);
    }
}

