/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.containers;

import com.intellij.util.containers.EmptyIntHashSet;
import com.intellij.util.indexing.containers.IntIdsIterator;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import org.jetbrains.annotations.NotNull;

public class TroveSetIntIterator
implements IntIdsIterator {
    @NotNull
    public static final TroveSetIntIterator EMPTY = new TroveSetIntIterator(EmptyIntHashSet.INSTANCE);
    @NotNull
    private final TIntHashSet mySet;
    @NotNull
    private final TIntIterator mySetIterator;
    private final int mySize;

    public TroveSetIntIterator(@NotNull TIntHashSet set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/util/indexing/containers/TroveSetIntIterator", "<init>"));
        }
        this.mySet = set;
        this.mySetIterator = set.iterator();
        this.mySize = set.size();
    }

    @Override
    public boolean hasNext() {
        return this.mySetIterator.hasNext();
    }

    @Override
    public int next() {
        return this.mySetIterator.next();
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public boolean hasAscendingOrder() {
        return false;
    }

    @Override
    public IntIdsIterator createCopyInInitialState() {
        return new TroveSetIntIterator(this.mySet);
    }
}

