/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import org.jetbrains.annotations.NotNull;

public class SingleCharSequence
implements CharSequence {
    private final char myCh;

    public SingleCharSequence(char ch) {
        this.myCh = ch;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public char charAt(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        return this.myCh;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == 1) {
            return this;
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("Start index out of range:" + start);
        }
        if (end > 1 || end < 0) {
            throw new IndexOutOfBoundsException("End index out of range:" + end);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("Start index should be less or equal to end index:" + start + " - " + end);
        }
        return "";
    }

    @Override
    @NotNull
    public String toString() {
        String string = String.valueOf(this.myCh);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/SingleCharSequence", "toString"));
        }
        return string;
    }
}

