/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.impl;

import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessorBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class PropertiesPsiTreeChangePreprocessor
extends PsiTreeChangePreprocessorBase {
    private static final TokenSet CODE_BLOCK_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{PropertiesTokenTypes.VALUE_CHARACTERS, PropertiesTokenTypes.END_OF_LINE_COMMENT, PropertiesTokenTypes.WHITE_SPACE, PropertiesTokenTypes.KEY_VALUE_SEPARATOR});

    public PropertiesPsiTreeChangePreprocessor(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/lang/properties/psi/impl/PropertiesPsiTreeChangePreprocessor", "<init>"));
        }
        super(psiManager);
    }

    protected void onTreeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/psi/impl/PropertiesPsiTreeChangePreprocessor", "onTreeChanged"));
        }
        if (event.isGenericChange()) {
            return;
        }
        switch (event.getCode()) {
            case BEFORE_PROPERTY_CHANGE: 
            case BEFORE_CHILD_REMOVAL: 
            case BEFORE_CHILD_ADDITION: 
            case BEFORE_CHILD_MOVEMENT: 
            case BEFORE_CHILDREN_CHANGE: 
            case BEFORE_CHILD_REPLACEMENT: {
                return;
            }
            case CHILD_ADDED: {
                if (!PropertiesPsiTreeChangePreprocessor.isCodeBlock(event.getChild())) break;
                return;
            }
            case CHILD_REMOVED: {
                if (!PropertiesPsiTreeChangePreprocessor.isCodeBlock(event.getChild())) break;
                return;
            }
            case CHILD_REPLACED: {
                if (!PropertiesPsiTreeChangePreprocessor.isCodeBlock(event.getOldChild()) && !PropertiesPsiTreeChangePreprocessor.isCodeBlock(event.getNewChild())) break;
                return;
            }
            case CHILD_MOVED: {
                if (!PropertiesPsiTreeChangePreprocessor.isCodeBlock(event.getChild())) break;
                return;
            }
            case CHILDREN_CHANGED: {
                if (!PropertiesPsiTreeChangePreprocessor.isCodeBlock(event.getParent())) break;
                return;
            }
        }
        this.doIncOutOfCodeBlockCounter();
    }

    protected boolean acceptsEvent(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/psi/impl/PropertiesPsiTreeChangePreprocessor", "acceptsEvent"));
        }
        return event.getFile() instanceof PropertiesFile;
    }

    protected boolean isOutOfCodeBlock(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/psi/impl/PropertiesPsiTreeChangePreprocessor", "isOutOfCodeBlock"));
        }
        throw new IllegalStateException();
    }

    private static boolean isCodeBlock(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/psi/impl/PropertiesPsiTreeChangePreprocessor", "isCodeBlock"));
        }
        return CODE_BLOCK_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)element));
    }
}

