/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;

public class CustomViewDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CustomViewDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("CustomViewStyleable", "Mismatched Styleable/Custom View Name", "The convention for custom views is to use a `declare-styleable` whose name matches the custom view class name. The IDE relies on this convention such that for example code completion can be offered for attributes in a custom view in layout XML resource files.\n\n(Similarly, layout parameter classes should use the suffix `_Layout`.)", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(OBTAIN_STYLED_ATTRIBUTES);
    }

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression node, PsiMethod method) {
        if (LintUtils.skipParentheses(node.getParent()) instanceof PsiExpressionStatement) {
            PsiExpression[] arguments;
            if (!context.getEvaluator().isMemberInSubClassOf((PsiMember)method, "android.content.Context", false)) {
                return;
            }
            int size = (arguments = node.getArgumentList().getExpressions()).length;
            int parameterIndex = size == 1 ? 0 : 1;
            PsiExpression expression = arguments[parameterIndex];
            String s = expression.getText();
            if (!s.startsWith("R.styleable.")) {
                return;
            }
            String styleableName = s.substring("R.styleable.".length());
            PsiClass cls = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)node, PsiClass.class, (boolean)false);
            if (cls == null) {
                return;
            }
            String className = cls.getName();
            if (context.getEvaluator().extendsClass(cls, "android.view.View", false)) {
                if (!styleableName.equals(className)) {
                    String message = String.format("By convention, the custom view (`%1$s`) and the declare-styleable (`%2$s`) should have the same name (various editor features rely on this convention)", className, styleableName);
                    context.report(ISSUE, (PsiElement)node, context.getLocation((PsiElement)expression), message);
                }
            } else if (context.getEvaluator().extendsClass(cls, "android.view.ViewGroup.LayoutParams", false)) {
                PsiClass outer = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)cls, PsiClass.class, (boolean)true);
                if (outer == null) {
                    return;
                }
                String layoutClassName = outer.getName();
                String expectedName = layoutClassName + "_Layout";
                if (!styleableName.equals(expectedName)) {
                    String message = String.format("By convention, the declare-styleable (`%1$s`) for a layout parameter class (`%2$s`) is expected to be the surrounding class (`%3$s`) plus \"`_Layout`\", e.g. `%4$s`. (Various editor features rely on this convention.)", styleableName, className, layoutClassName, expectedName);
                    context.report(ISSUE, (PsiElement)node, context.getLocation((PsiElement)expression), message);
                }
            }
        }
    }
}

