/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;

public class DateFormatDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(DateFormatDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue DATE_FORMAT = Issue.create("SimpleDateFormat", "Implied locale in date format", "Almost all callers should use `getDateInstance()`, `getDateTimeInstance()`, or `getTimeInstance()` to get a ready-made instance of SimpleDateFormat suitable for the user's locale. The main reason you'd create an instance this class directly is because you need to format/parse a specific machine-readable format, in which case you almost certainly want to explicitly ask for US to ensure that you get ASCII digits (rather than, say, Arabic digits).\n\nTherefore, you should either use the form of the SimpleDateFormat constructor where you pass in an explicit locale, such as Locale.US, or use one of the get instance methods, or suppress this error if really know what you are doing.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/reference/java/text/SimpleDateFormat.html");
    public static final String LOCALE_CLS = "java.util.Locale";
    public static final String SIMPLE_DATE_FORMAT_CLS = "java.text.SimpleDateFormat";

    @Override
    public List<String> getApplicableConstructorTypes() {
        return Collections.singletonList(SIMPLE_DATE_FORMAT_CLS);
    }

    @Override
    public void visitConstructor(JavaContext context, JavaElementVisitor visitor, PsiNewExpression node, PsiMethod constructor) {
        if (!DateFormatDetector.specifiesLocale(constructor)) {
            Location location = context.getLocation((PsiElement)node);
            String message = "To get local formatting use `getDateInstance()`, `getDateTimeInstance()`, or `getTimeInstance()`, or use `new SimpleDateFormat(String template, Locale locale)` with for example `Locale.US` for ASCII dates.";
            context.report(DATE_FORMAT, (PsiElement)node, location, message);
        }
    }

    private static boolean specifiesLocale(PsiMethod method) {
        PsiParameter[] parameters;
        PsiParameterList parameterList = method.getParameterList();
        for (PsiParameter parameter : parameters = parameterList.getParameters()) {
            PsiType type = parameter.getType();
            if (!type.getCanonicalText().equals(LOCALE_CLS)) continue;
            return true;
        }
        return false;
    }
}

