/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;

public class HandlerDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create("HandlerLeak", "Handler reference leaks", "Since this Handler is declared as an inner class, it may prevent the outer class from being garbage collected. If the Handler is using a Looper or MessageQueue for a thread other than the main thread, then there is no issue. If the Handler is using the Looper or MessageQueue of the main thread, you need to fix your Handler declaration, as follows: Declare the Handler as a static class; In the outer class, instantiate a WeakReference to the outer class and pass this object to your Handler when you instantiate the Handler; Make all references to members of the outer class using the WeakReference object.", Category.PERFORMANCE, 4, Severity.WARNING, new Implementation(HandlerDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String LOOPER_CLS = "android.os.Looper";
    private static final String HANDLER_CLS = "android.os.Handler";

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList(HANDLER_CLS);
    }

    @Override
    public void checkClass(JavaContext context, PsiClass declaration) {
        PsiElement locationNode;
        if (context.getEvaluator().isStatic((PsiModifierListOwner)declaration)) {
            return;
        }
        boolean isAnonymous = declaration instanceof PsiAnonymousClass;
        if (declaration.getContainingClass() == null && !isAnonymous) {
            return;
        }
        PsiNewExpression invocation = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)declaration, PsiNewExpression.class, (boolean)true, (Class[])new Class[]{PsiMethod.class});
        if (invocation != null) {
            PsiExpressionList argumentList = invocation.getArgumentList();
            if (argumentList != null && isAnonymous) {
                ((PsiAnonymousClass)declaration).getArgumentList();
                for (PsiExpression expression : argumentList.getExpressions()) {
                    PsiType type = expression.getType();
                    if (!(type instanceof PsiClassType) || !LOOPER_CLS.equals(type.getCanonicalText())) continue;
                    return;
                }
            }
        } else if (HandlerDetector.hasLooperConstructorParameter(declaration)) {
            return;
        }
        if ((locationNode = JavaContext.findNameElement((PsiElement)declaration)) == null) {
            locationNode = declaration;
        }
        Location location = context.getLocation(locationNode);
        String name = isAnonymous ? "anonymous " + ((PsiAnonymousClass)declaration).getBaseClassReference().getQualifiedName() : declaration.getQualifiedName();
        context.report(ISSUE, locationNode, location, String.format("This Handler class should be static or leaks might occur (%1$s)", name));
    }

    private static boolean hasLooperConstructorParameter(PsiClass cls) {
        for (PsiMethod constructor : cls.getConstructors()) {
            for (PsiParameter parameter : constructor.getParameterList().getParameters()) {
                PsiType type = parameter.getType();
                if (!LOOPER_CLS.equals(type.getCanonicalText())) continue;
                return true;
            }
        }
        return false;
    }
}

