/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergeRootFrameLayoutDetector
extends LayoutDetector
implements Detector.JavaPsiScanner {
    private Set<String> mWhitelistedLayouts;
    private List<Pair<String, Location.Handle>> mPending;
    public static final Issue ISSUE = Issue.create("MergeRootFrame", "FrameLayout can be replaced with `<merge>` tag", "If a `<FrameLayout>` is the root of a layout and does not provide background or padding etc, it can often be replaced with a `<merge>` tag which is slightly more efficient. Note that this depends on context, so make sure you understand how the `<merge>` tag works before proceeding.", Category.PERFORMANCE, 4, Severity.WARNING, new Implementation(MergeRootFrameLayoutDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE))).addMoreInfo("http://android-developers.blogspot.com/2009/03/android-layout-tricks-3-optimize-by.html");

    @Override
    public void afterCheckProject(Context context) {
        if (this.mPending != null && this.mWhitelistedLayouts != null) {
            for (Pair<String, Location.Handle> pair : this.mPending) {
                String layout = (String)pair.getFirst();
                if (!this.mWhitelistedLayouts.contains(layout)) continue;
                Location.Handle handle = (Location.Handle)pair.getSecond();
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && context.getDriver().isSuppressed(null, ISSUE, (Node)clientData)) {
                    return;
                }
                Location location = handle.resolve();
                context.report(ISSUE, location, "This `<FrameLayout>` can be replaced with a `<merge>` tag");
            }
        }
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("include", "FrameLayout");
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        String tag = element.getTagName();
        if (tag.equals("include")) {
            String layout = element.getAttribute("layout");
            if (layout.startsWith("@layout/")) {
                layout = layout.substring("@layout/".length());
                this.whiteListLayout(layout);
            }
        } else {
            assert (tag.equals("FrameLayout"));
            if (LintUtils.isRootElement(element) && (MergeRootFrameLayoutDetector.isWidthFillParent(element) && MergeRootFrameLayoutDetector.isHeightFillParent(element) || !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_gravity")) && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "foreground") && !this.hasPadding(element)) {
                String layout = LintUtils.getLayoutName(context.file);
                Location.Handle handle = context.createLocationHandle(element);
                handle.setClientData(element);
                if (!context.getProject().getReportIssues()) {
                    return;
                }
                if (this.mPending == null) {
                    this.mPending = new ArrayList<Pair<String, Location.Handle>>();
                }
                this.mPending.add((Pair<String, Location.Handle>)Pair.of((Object)layout, (Object)handle));
            }
        }
    }

    private void whiteListLayout(String layout) {
        if (this.mWhitelistedLayouts == null) {
            this.mWhitelistedLayouts = new HashSet<String>();
        }
        this.mWhitelistedLayouts.add(layout);
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setContentView");
    }

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression call, PsiMethod method) {
        PsiReferenceExpression expression;
        PsiExpression[] expressions = call.getArgumentList().getExpressions();
        if (expressions.length == 1 && expressions[0] instanceof PsiReferenceExpression && (expression = (PsiReferenceExpression)expressions[0]).getQualifier() instanceof PsiReferenceExpression) {
            String layoutName;
            PsiReferenceExpression inner = (PsiReferenceExpression)expression.getQualifier();
            if (ResourceType.LAYOUT.getName().equals(inner.getReferenceName()) && (layoutName = expression.getReferenceName()) != null) {
                this.whiteListLayout(layoutName);
            }
        }
    }
}

