/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import java.util.Arrays;
import java.util.List;

public class ReadParcelableDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create("ParcelClassLoader", "Default Parcel Class Loader", "The documentation for `Parcel#readParcelable(ClassLoader)` (and its variations) says that you can pass in `null` to pick up the default class loader. However, that ClassLoader is a system class loader and is not able to find classes in your own application.\n\nIf you are writing your own classes into the `Parcel` (not just SDK classes like `String` and so on), then you should supply a `ClassLoader` for your application instead; a simple way to obtain one is to just call `getClass().getClassLoader()` from your own class.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ReadParcelableDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/os/Parcel.html");

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("readParcelable", "readParcelableArray", "readBundle", "readArray", "readSparseArray", "readValue", "readPersistableBundle");
    }

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression node, PsiMethod method) {
        PsiExpression parameter;
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (!"android.os.Parcel".equals(containingClass.getQualifiedName())) {
            return;
        }
        PsiExpressionList argumentList = node.getArgumentList();
        PsiExpression[] expressions = argumentList.getExpressions();
        int argumentCount = expressions.length;
        if (argumentCount == 0) {
            PsiElement name = node.getMethodExpression().getReferenceNameElement();
            assert (name != null);
            String message = String.format("Using the default class loader will not work if you are restoring your own classes. Consider using for example `%1$s(getClass().getClassLoader())` instead.", name.getText());
            Location location = context.getRangeLocation(name, 0, name, 2);
            context.report(ISSUE, (PsiElement)node, location, message);
        } else if (argumentCount == 1 && LintUtils.isNullLiteral((PsiElement)(parameter = expressions[0]))) {
            String message = "Passing null here (to use the default class loader) will not work if you are restoring your own classes. Consider using for example `getClass().getClassLoader()` instead.";
            PsiElement name = node.getMethodExpression().getReferenceNameElement();
            assert (name != null);
            Location location = context.getRangeLocation(name, 0, (PsiElement)parameter, 1);
            context.report(ISSUE, (PsiElement)node, location, message);
        }
    }
}

