/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatement;
import java.util.Collections;
import java.util.List;

public class WrongImportDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create("SuspiciousImport", "'`import android.R`' statement", "Importing `android.R` is usually not intentional; it sometimes happens when you use an IDE and ask it to automatically add imports at a time when your project's R class it not present.\n\nOnce the import is there you might get a lot of \"confusing\" error messages because of course the fields available on `android.R` are not the ones you'd expect from just looking at your own `R` class.", Category.CORRECTNESS, 9, Severity.WARNING, new Implementation(WrongImportDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Collections.singletonList(PsiImportStatement.class);
    }

    @Override
    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        return new ImportVisitor(context);
    }

    private static class ImportVisitor
    extends JavaElementVisitor {
        private final JavaContext mContext;

        public ImportVisitor(JavaContext context) {
            this.mContext = context;
        }

        public void visitImportStatement(PsiImportStatement statement) {
            String qualifiedName = statement.getQualifiedName();
            if ("android.R".equals(qualifiedName)) {
                Location location = this.mContext.getLocation((PsiElement)statement);
                this.mContext.report(ISSUE, (PsiElement)statement, location, "Don't include `android.R` here; use a fully qualified name for each usage instead");
            }
        }
    }
}

