/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;
import org.jetbrains.plugins.github.api.data.GithubCommitSha;
import org.jetbrains.plugins.github.api.data.GithubUser;

@RestModel
public class GithubCommit
extends GithubCommitSha {
    private GithubUser author;
    private GithubUser committer;
    @Mandatory
    private GitCommit commit;
    @Mandatory
    private List<GithubCommitSha> parents;

    @Nullable
    public GithubUser getAuthor() {
        return this.author;
    }

    @Nullable
    public GithubUser getCommitter() {
        return this.committer;
    }

    @NotNull
    public List<GithubCommitSha> getParents() {
        List<GithubCommitSha> list = this.parents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubCommit", "getParents"));
        }
        return list;
    }

    @NotNull
    public GitCommit getCommit() {
        GitCommit gitCommit = this.commit;
        if (gitCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubCommit", "getCommit"));
        }
        return gitCommit;
    }

    @RestModel
    public static class GitUser {
        @Mandatory
        private String name;
        @Mandatory
        private String email;
        @Mandatory
        private Date date;

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubCommit$GitUser", "getName"));
            }
            return string;
        }

        @NotNull
        public String getEmail() {
            String string = this.email;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubCommit$GitUser", "getEmail"));
            }
            return string;
        }

        @NotNull
        public Date getDate() {
            Date date = this.date;
            if (date == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubCommit$GitUser", "getDate"));
            }
            return date;
        }
    }

    @RestModel
    public static class GitCommit {
        private String url;
        @Mandatory
        private String message;
        @Mandatory
        private GitUser author;
        @Mandatory
        private GitUser committer;

        @NotNull
        public String getMessage() {
            String string = this.message;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubCommit$GitCommit", "getMessage"));
            }
            return string;
        }

        @NotNull
        public GitUser getAuthor() {
            GitUser gitUser = this.author;
            if (gitUser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubCommit$GitCommit", "getAuthor"));
            }
            return gitUser;
        }

        @NotNull
        public GitUser getCommitter() {
            GitUser gitUser = this.committer;
            if (gitUser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubCommit$GitCommit", "getCommitter"));
            }
            return gitUser;
        }
    }
}

