/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;
import org.jetbrains.plugins.github.api.data.GithubUser;

@RestModel
public class GithubGist {
    @Mandatory
    private String id;
    private String description;
    @SerializedName(value="public")
    @Mandatory
    private Boolean isPublic;
    private String url;
    @Mandatory
    private String htmlUrl;
    private String gitPullUrl;
    private String gitPushUrl;
    @Mandatory
    private Map<String, GistFile> files;
    private GithubUser owner;
    private Date createdAt;

    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubGist", "getId"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = StringUtil.notNullize((String)this.description);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubGist", "getDescription"));
        }
        return string;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    @NotNull
    public String getHtmlUrl() {
        String string = this.htmlUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubGist", "getHtmlUrl"));
        }
        return string;
    }

    @NotNull
    public List<GistFile> getFiles() {
        ArrayList<GistFile> arrayList = new ArrayList<GistFile>(this.files.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubGist", "getFiles"));
        }
        return arrayList;
    }

    @Nullable
    public GithubUser getUser() {
        return this.owner;
    }

    @RestModel
    public static class GistFile {
        private Long size;
        @Mandatory
        private String filename;
        @Mandatory
        private String content;
        @Mandatory
        private String raw_url;
        private String type;
        private String language;

        @NotNull
        public String getFilename() {
            String string = this.filename;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubGist$GistFile", "getFilename"));
            }
            return string;
        }

        @NotNull
        public String getContent() {
            String string = this.content;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubGist$GistFile", "getContent"));
            }
            return string;
        }

        @NotNull
        public String getRawUrl() {
            String string = this.raw_url;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubGist$GistFile", "getRawUrl"));
            }
            return string;
        }
    }
}

