/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.util.ObjectMap;

public class IntMap<V> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    private static final int EMPTY = 0;
    public int size;
    int[] keyTable;
    V[] valueTable;
    int capacity;
    int stashSize;
    V zeroValue;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;

    public IntMap() {
        this(32, 0.8f);
    }

    public IntMap(int n) {
        this(n, 0.8f);
    }

    public IntMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n);
        }
        if (this.capacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n);
        }
        this.capacity = ObjectMap.nextPowerOfTwo(n);
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f);
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new int[this.capacity + this.stashCapacity];
        this.valueTable = new Object[this.keyTable.length];
    }

    public V put(int n, V v) {
        int n2;
        if (n == 0) {
            V v2 = this.zeroValue;
            this.zeroValue = v;
            this.hasZeroValue = true;
            ++this.size;
            return v2;
        }
        int[] nArray = this.keyTable;
        int n3 = n & this.mask;
        int n4 = nArray[n3];
        if (n4 == n) {
            V v3 = this.valueTable[n3];
            this.valueTable[n3] = v;
            return v3;
        }
        int n5 = this.hash2(n);
        int n6 = nArray[n5];
        if (n6 == n) {
            V v4 = this.valueTable[n5];
            this.valueTable[n5] = v;
            return v4;
        }
        int n7 = this.hash3(n);
        int n8 = nArray[n7];
        if (n8 == n) {
            V v5 = this.valueTable[n7];
            this.valueTable[n7] = v;
            return v5;
        }
        int n9 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n9; ++n2) {
            if (n != nArray[n2]) continue;
            V v6 = this.valueTable[n2];
            this.valueTable[n2] = v;
            return v6;
        }
        if (n4 == 0) {
            nArray[n3] = n;
            this.valueTable[n3] = v;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (n6 == 0) {
            nArray[n5] = n;
            this.valueTable[n5] = v;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (n8 == 0) {
            nArray[n7] = n;
            this.valueTable[n7] = v;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(n, v, n3, n4, n5, n6, n7, n8);
        return null;
    }

    private void putResize(int n, V v) {
        if (n == 0) {
            this.zeroValue = v;
            this.hasZeroValue = true;
            return;
        }
        int n2 = n & this.mask;
        int n3 = this.keyTable[n2];
        if (n3 == 0) {
            this.keyTable[n2] = n;
            this.valueTable[n2] = v;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash2(n);
        int n5 = this.keyTable[n4];
        if (n5 == 0) {
            this.keyTable[n4] = n;
            this.valueTable[n4] = v;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n6 = this.hash3(n);
        int n7 = this.keyTable[n6];
        if (n7 == 0) {
            this.keyTable[n6] = n;
            this.valueTable[n6] = v;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n, v, n2, n3, n4, n5, n6, n7);
    }

    private void push(int n, V v, int n2, int n3, int n4, int n5, int n6, int n7) {
        V v2;
        int n8;
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n9 = this.mask;
        int n10 = 0;
        int n11 = this.pushIterations;
        while (true) {
            switch (ObjectMap.random.nextInt(3)) {
                case 0: {
                    n8 = n3;
                    v2 = VArray[n2];
                    nArray[n2] = n;
                    VArray[n2] = v;
                    break;
                }
                case 1: {
                    n8 = n5;
                    v2 = VArray[n4];
                    nArray[n4] = n;
                    VArray[n4] = v;
                    break;
                }
                default: {
                    n8 = n7;
                    v2 = VArray[n6];
                    nArray[n6] = n;
                    VArray[n6] = v;
                }
            }
            n2 = n8 & n9;
            n3 = nArray[n2];
            if (n3 == 0) {
                nArray[n2] = n8;
                VArray[n2] = v2;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash2(n8);
            n5 = nArray[n4];
            if (n5 == 0) {
                nArray[n4] = n8;
                VArray[n4] = v2;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n6 = this.hash3(n8);
            n7 = nArray[n6];
            if (n7 == 0) {
                nArray[n6] = n8;
                VArray[n6] = v2;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n10 == n11) break;
            n = n8;
            v = v2;
        }
        this.putStash(n8, v2);
    }

    private void putStash(int n, V v) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(n, v);
            return;
        }
        int n2 = this.capacity + this.stashSize;
        this.keyTable[n2] = n;
        this.valueTable[n2] = v;
        ++this.stashSize;
        ++this.size;
    }

    public V get(int n) {
        if (n == 0) {
            return this.zeroValue;
        }
        int n2 = n & this.mask;
        if (this.keyTable[n2] != n && this.keyTable[n2 = this.hash2(n)] != n && this.keyTable[n2 = this.hash3(n)] != n) {
            return this.getStash(n, null);
        }
        return this.valueTable[n2];
    }

    public V get(int n, V v) {
        if (n == 0) {
            return this.zeroValue;
        }
        int n2 = n & this.mask;
        if (this.keyTable[n2] != n && this.keyTable[n2 = this.hash2(n)] != n && this.keyTable[n2 = this.hash3(n)] != n) {
            return this.getStash(n, v);
        }
        return this.valueTable[n2];
    }

    private V getStash(int n, V v) {
        int n2;
        int[] nArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (nArray[n2] != n) continue;
            return this.valueTable[n2];
        }
        return v;
    }

    public V remove(int n) {
        if (n == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            V v = this.zeroValue;
            this.zeroValue = null;
            this.hasZeroValue = false;
            --this.size;
            return v;
        }
        int n2 = n & this.mask;
        if (this.keyTable[n2] == n) {
            this.keyTable[n2] = 0;
            V v = this.valueTable[n2];
            this.valueTable[n2] = null;
            --this.size;
            return v;
        }
        n2 = this.hash2(n);
        if (this.keyTable[n2] == n) {
            this.keyTable[n2] = 0;
            V v = this.valueTable[n2];
            this.valueTable[n2] = null;
            --this.size;
            return v;
        }
        n2 = this.hash3(n);
        if (this.keyTable[n2] == n) {
            this.keyTable[n2] = 0;
            V v = this.valueTable[n2];
            this.valueTable[n2] = null;
            --this.size;
            return v;
        }
        return this.removeStash(n);
    }

    V removeStash(int n) {
        int n2;
        int[] nArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (nArray[n2] != n) continue;
            V v = this.valueTable[n2];
            this.removeStashIndex(n2);
            --this.size;
            return v;
        }
        return null;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            this.keyTable[n] = this.keyTable[n2];
            this.valueTable[n] = this.valueTable[n2];
            this.valueTable[n2] = null;
        } else {
            this.valueTable[n] = null;
        }
    }

    public void shrink(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n);
        }
        if (this.size > n) {
            n = this.size;
        }
        if (this.capacity <= n) {
            return;
        }
        n = ObjectMap.nextPowerOfTwo(n);
        this.resize(n);
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.zeroValue = null;
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n);
    }

    public void clear() {
        int n;
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        for (n = this.size - 1; n >= 0; --n) {
            nArray[n] = 0;
            VArray[n] = null;
        }
        int n2 = n + this.stashSize - 1;
        for (n = this.capacity; n < n2; ++n) {
            nArray[n] = 0;
            VArray[n] = null;
        }
        this.size = 0;
        this.stashSize = 0;
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    public boolean containsValue(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            int[] nArray = this.keyTable;
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (nArray[n] == 0 || VArray[n] != null) continue;
                return true;
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return true;
            }
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (VArray[n] != object) continue;
                return true;
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return true;
            }
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (!object.equals(VArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(int n) {
        if (n == 0) {
            return this.hasZeroValue;
        }
        int n2 = n & this.mask;
        if (this.keyTable[n2] != n && this.keyTable[n2 = this.hash2(n)] != n && this.keyTable[n2 = this.hash3(n)] != n) {
            return this.containsKeyStash(n);
        }
        return true;
    }

    private boolean containsKeyStash(int n) {
        int n2;
        int[] nArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (nArray[n2] != n) continue;
            return true;
        }
        return false;
    }

    public int findKey(Object object, boolean bl, int n) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0;
            }
            int[] nArray = this.keyTable;
            int n2 = this.capacity + this.stashSize;
            while (n2-- > 0) {
                if (nArray[n2] == 0 || VArray[n2] != null) continue;
                return nArray[n2];
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return 0;
            }
            int n3 = this.capacity + this.stashSize;
            while (n3-- > 0) {
                if (VArray[n3] != object) continue;
                return this.keyTable[n3];
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return 0;
            }
            int n4 = this.capacity + this.stashSize;
            while (n4-- > 0) {
                if (!object.equals(VArray[n4])) continue;
                return this.keyTable[n4];
            }
        }
        return n;
    }

    public void ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 >= this.threshold) {
            this.resize(ObjectMap.nextPowerOfTwo((int)((float)n2 / this.loadFactor)));
        }
    }

    private void resize(int n) {
        int n2 = this.capacity + this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new int[n + this.stashCapacity];
        this.valueTable = new Object[n + this.stashCapacity];
        int n3 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n3 > 0) {
            for (int i = 0; i < n2; ++i) {
                int n4 = nArray[i];
                if (n4 == 0) continue;
                this.putResize(n4, VArray[i]);
            }
        }
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    public String toString() {
        int n;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = nArray.length;
        while (n2-- > 0) {
            n = nArray[n2];
            if (n == 0) continue;
            stringBuilder.append(n);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n2]);
            break;
        }
        while (n2-- > 0) {
            n = nArray[n2];
            if (n == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

