/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.testIntegration.TestFramework;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestFrameworks {
    public static TestFrameworks getInstance() {
        return ServiceManager.getService(TestFrameworks.class);
    }

    public abstract boolean isTestClass(PsiClass var1);

    public abstract boolean isPotentialTestClass(PsiClass var1);

    @Nullable
    public abstract PsiMethod findOrCreateSetUpMethod(PsiClass var1);

    @Nullable
    public abstract PsiMethod findSetUpMethod(PsiClass var1);

    @Nullable
    public abstract PsiMethod findTearDownMethod(PsiClass var1);

    protected abstract boolean hasConfigMethods(PsiClass var1);

    public abstract boolean isTestMethod(PsiMethod var1);

    public boolean isTestOrConfig(PsiClass psiClass) {
        return this.isTestClass(psiClass) || this.hasConfigMethods(psiClass);
    }

    @Nullable
    public static TestFramework detectFramework(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/TestFrameworks", "detectFramework"));
        }
        return (TestFramework)CachedValuesManager.getCachedValue(psiClass, () -> {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/TestFrameworks", "lambda$detectFramework$0"));
            }
            return CachedValueProvider.Result.create(TestFrameworks.computeFramework(psiClass), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
    }

    @Nullable
    private static TestFramework computeFramework(PsiClass psiClass) {
        for (TestFramework framework : (TestFramework[])Extensions.getExtensions(TestFramework.EXTENSION_NAME)) {
            if (!framework.isTestClass(psiClass)) continue;
            return framework;
        }
        for (TestFramework framework : (TestFramework[])Extensions.getExtensions(TestFramework.EXTENSION_NAME)) {
            if (framework.findSetUpMethod(psiClass) == null && framework.findTearDownMethod(psiClass) == null) continue;
            return framework;
        }
        return null;
    }
}

