/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.ResourceUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionProfileEntry
implements BatchSuppressableTool {
    public static final String GENERAL_GROUP_NAME = InspectionsBundle.message("inspection.general.tools.group.name", new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.InspectionProfileEntry");
    private static final SerializationFilter DEFAULT_FILTER = new SkipDefaultValuesSerializationFilters();
    private static Set<String> ourBlackList;
    private static final Object BLACK_LIST_LOCK;
    private Boolean myUseNewSerializer;
    protected volatile DefaultNameProvider myNameProvider;

    @NonNls
    @Nullable
    public String getAlternativeID() {
        return null;
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/InspectionProfileEntry", "isSuppressedFor"));
        }
        Set<InspectionSuppressor> suppressors = InspectionProfileEntry.getSuppressors(element);
        String toolId = this.getSuppressId();
        for (InspectionSuppressor suppressor : suppressors) {
            if (!this.isSuppressed(toolId, suppressor, element)) continue;
            return true;
        }
        InspectionElementsMerger merger = InspectionElementsMerger.getMerger(this.getShortName());
        if (merger != null) {
            String[] sourceToolIds;
            String[] suppressIds = merger.getSuppressIds();
            for (String sourceToolId : sourceToolIds = suppressIds.length != 0 ? suppressIds : merger.getSourceToolNames()) {
                for (InspectionSuppressor suppressor : suppressors) {
                    if (!suppressor.isSuppressedFor(element, sourceToolId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    protected String getSuppressId() {
        String string = this.getShortName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getSuppressId"));
        }
        return string;
    }

    @Override
    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        if (element == null) {
            if (SuppressQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getBatchSuppressActions"));
            }
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        THashSet fixes = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<SuppressQuickFix>(){

            public int computeHashCode(SuppressQuickFix object) {
                int result = object instanceof InjectionAwareSuppressQuickFix ? ((InjectionAwareSuppressQuickFix)object).isShouldBeAppliedToInjectionHost().hashCode() : 0;
                return 31 * result + object.getName().hashCode();
            }

            public boolean equals(SuppressQuickFix o1, SuppressQuickFix o2) {
                if (o1 instanceof InjectionAwareSuppressQuickFix && o2 instanceof InjectionAwareSuppressQuickFix && ((InjectionAwareSuppressQuickFix)o1).isShouldBeAppliedToInjectionHost() != ((InjectionAwareSuppressQuickFix)o2).isShouldBeAppliedToInjectionHost()) {
                    return false;
                }
                return o1.getName().equals(o2.getName());
            }
        });
        Set<InspectionSuppressor> suppressors = InspectionProfileEntry.getSuppressors(element);
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance(element.getProject()).getInjectionHost(element);
        if (injectionHost != null) {
            Set<InspectionSuppressor> injectionHostSuppressors = InspectionProfileEntry.getSuppressors(injectionHost);
            for (InspectionSuppressor suppressor : injectionHostSuppressors) {
                InspectionProfileEntry.addAllSuppressActions((Set<SuppressQuickFix>)fixes, injectionHost, suppressor, ThreeState.YES, this.getSuppressId());
            }
        }
        for (InspectionSuppressor suppressor : suppressors) {
            InspectionProfileEntry.addAllSuppressActions((Set<SuppressQuickFix>)fixes, element, suppressor, injectionHost != null ? ThreeState.NO : ThreeState.UNSURE, this.getSuppressId());
        }
        SuppressQuickFix[] suppressQuickFixArray = fixes.toArray(new SuppressQuickFix[fixes.size()]);
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getBatchSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    private static void addAllSuppressActions(@NotNull Set<SuppressQuickFix> fixes, @NotNull PsiElement element, @NotNull InspectionSuppressor suppressor, @NotNull ThreeState appliedToInjectionHost, @NotNull String toolId) {
        SuppressQuickFix[] actions;
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/codeInspection/InspectionProfileEntry", "addAllSuppressActions"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/InspectionProfileEntry", "addAllSuppressActions"));
        }
        if (suppressor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suppressor", "com/intellij/codeInspection/InspectionProfileEntry", "addAllSuppressActions"));
        }
        if (appliedToInjectionHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appliedToInjectionHost", "com/intellij/codeInspection/InspectionProfileEntry", "addAllSuppressActions"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/InspectionProfileEntry", "addAllSuppressActions"));
        }
        for (SuppressQuickFix action : actions = suppressor.getSuppressActions(element, toolId)) {
            if (action instanceof InjectionAwareSuppressQuickFix) {
                ((InjectionAwareSuppressQuickFix)action).setShouldBeAppliedToInjectionHost(appliedToInjectionHost);
            }
            fixes.add(action);
        }
    }

    private boolean isSuppressed(@NotNull String toolId, @NotNull InspectionSuppressor suppressor, @NotNull PsiElement element) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/InspectionProfileEntry", "isSuppressed"));
        }
        if (suppressor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suppressor", "com/intellij/codeInspection/InspectionProfileEntry", "isSuppressed"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/InspectionProfileEntry", "isSuppressed"));
        }
        if (suppressor.isSuppressedFor(element, toolId)) {
            return true;
        }
        String alternativeId = this.getAlternativeID();
        return alternativeId != null && !alternativeId.equals(toolId) && suppressor.isSuppressedFor(element, alternativeId);
    }

    @NotNull
    public static Set<InspectionSuppressor> getSuppressors(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/InspectionProfileEntry", "getSuppressors"));
        }
        FileViewProvider viewProvider = element.getContainingFile().getViewProvider();
        InspectionSuppressor elementLanguageSuppressor = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(element.getLanguage());
        if (viewProvider instanceof TemplateLanguageFileViewProvider) {
            LinkedHashSet<InspectionSuppressor> suppressors = new LinkedHashSet<InspectionSuppressor>();
            ContainerUtil.addIfNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.forLanguage(viewProvider.getBaseLanguage()));
            for (Language language : viewProvider.getLanguages()) {
                ContainerUtil.addIfNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.forLanguage(language));
            }
            ContainerUtil.addIfNotNull(suppressors, (Object)elementLanguageSuppressor);
            LinkedHashSet<InspectionSuppressor> linkedHashSet = suppressors;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getSuppressors"));
            }
            return linkedHashSet;
        }
        if (!element.getLanguage().isKindOf(viewProvider.getBaseLanguage())) {
            LinkedHashSet<InspectionSuppressor> suppressors = new LinkedHashSet<InspectionSuppressor>();
            ContainerUtil.addIfNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.forLanguage(viewProvider.getBaseLanguage()));
            ContainerUtil.addIfNotNull(suppressors, (Object)elementLanguageSuppressor);
            LinkedHashSet<InspectionSuppressor> linkedHashSet = suppressors;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getSuppressors"));
            }
            return linkedHashSet;
        }
        Set<InspectionSuppressor> set = elementLanguageSuppressor != null ? Collections.singleton(elementLanguageSuppressor) : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getSuppressors"));
        }
        return set;
    }

    public void cleanup(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/InspectionProfileEntry", "cleanup"));
        }
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultGroupDisplayName()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getGroupDisplayName"));
            }
            return string;
        }
        LOG.error(this.getClass() + ": group display name should be overridden or configured via XML " + this.getClass());
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getGroupDisplayName"));
        }
        return "";
    }

    @NotNull
    public String[] getGroupPath() {
        String groupDisplayName = this.getGroupDisplayName();
        if (groupDisplayName.isEmpty()) {
            groupDisplayName = GENERAL_GROUP_NAME;
        }
        String[] stringArray = new String[]{groupDisplayName};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getGroupPath"));
        }
        return stringArray;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultDisplayName()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getDisplayName"));
            }
            return string;
        }
        LOG.error(this.getClass() + ": display name should be overridden or configured via XML " + this.getClass());
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getDisplayName"));
        }
        return "";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultShortName()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getShortName"));
            }
            return string;
        }
        String string = InspectionProfileEntry.getShortName(this.getClass().getSimpleName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getShortName"));
        }
        return string;
    }

    @NotNull
    public static String getShortName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInspection/InspectionProfileEntry", "getShortName"));
        }
        String string = StringUtil.trimEnd((String)StringUtil.trimEnd((String)className, (String)"Inspection"), (String)"InspectionBase");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getShortName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return null;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/InspectionProfileEntry", "readSettings"));
        }
        if (this.useNewSerializer()) {
            try {
                XmlSerializer.deserializeInto((Object)this, (Element)node);
            }
            catch (XmlSerializationException e) {
                throw new InvalidDataException((Throwable)e);
            }
        } else {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)node);
        }
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/InspectionProfileEntry", "writeSettings"));
        }
        if (this.useNewSerializer()) {
            XmlSerializer.serializeInto((Object)this, (Element)node, (SerializationFilter)this.getSerializationFilter());
        } else {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)node);
        }
    }

    private synchronized boolean useNewSerializer() {
        if (this.myUseNewSerializer == null) {
            this.myUseNewSerializer = !InspectionProfileEntry.getBlackList().contains(this.getClass().getName());
        }
        return this.myUseNewSerializer;
    }

    private static void loadBlackList() {
        ourBlackList = ContainerUtil.newHashSet();
        URL url = InspectionProfileEntry.class.getResource("inspection-black-list.txt");
        if (url == null) {
            LOG.error("Resource not found");
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                ourBlackList.add(line);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load resource: " + url, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static Collection<String> getBlackList() {
        Object object = BLACK_LIST_LOCK;
        // MONITORENTER : object
        if (ourBlackList == null) {
            InspectionProfileEntry.loadBlackList();
        }
        Set<String> set = ourBlackList;
        // MONITOREXIT : object
        if (set != null) return set;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getBlackList"));
    }

    @Nullable
    protected SerializationFilter getSerializationFilter() {
        return DEFAULT_FILTER;
    }

    @Nullable
    public String getStaticDescription() {
        return null;
    }

    @Nullable
    public String getDescriptionFileName() {
        return null;
    }

    @Nullable
    protected URL getDescriptionUrl() {
        String fileName = this.getDescriptionFileName();
        if (fileName == null) {
            return null;
        }
        return ResourceUtil.getResource(this.getDescriptionContextClass(), (String)"/inspectionDescriptions", (String)fileName);
    }

    @NotNull
    protected Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        Class<?> clazz = this.getClass();
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getDescriptionContextClass"));
        }
        return clazz;
    }

    public boolean isInitialized() {
        return true;
    }

    @Nullable
    public String getMainToolId() {
        return null;
    }

    @Nullable
    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            URL descriptionUrl = this.getDescriptionUrl();
            if (descriptionUrl == null) {
                return null;
            }
            return ResourceUtil.loadText((URL)descriptionUrl);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        BLACK_LIST_LOCK = new Object();
    }

    static interface DefaultNameProvider {
        @Nullable
        public String getDefaultShortName();

        @Nullable
        public String getDefaultDisplayName();

        @Nullable
        public String getDefaultGroupDisplayName();
    }
}

