/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.JavaTestUtil;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.ExecutionWithDebuggerToolsTestCase;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.RemoteStateState;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.impl.InvokeThread;
import com.intellij.debugger.impl.SynchronizationBasedSemaphore;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.Location;
import com.sun.jdi.Value;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class DebuggerTestCase
extends ExecutionWithDebuggerToolsTestCase {
    public static final int DEFAULT_ADDRESS = 3456;
    protected DebuggerSession myDebuggerSession;
    protected final AtomicInteger myRestart = new AtomicInteger();
    private static final int MAX_RESTARTS = 3;
    private volatile UsefulTestCase.TestDisposable myTestRootDisposable;
    private final List<Runnable> myTearDownRunnables = new ArrayList<Runnable>();

    protected void initApplication() throws Exception {
        super.initApplication();
        JavaTestUtil.setupTestJDK();
        DebuggerSettings.getInstance().DEBUGGER_TRANSPORT = 0;
        DebuggerSettings.getInstance().SKIP_CONSTRUCTORS = false;
        DebuggerSettings.getInstance().SKIP_GETTERS = false;
        NodeRendererSettings.getInstance().getClassRenderer().SHOW_DECLARED_TYPE = true;
    }

    @Override
    protected void runTest() throws Throwable {
        super.runTest();
        if (this.getDebugProcess() != null) {
            this.getDebugProcess().getProcessHandler().startNotify();
            this.waitProcess(this.getDebugProcess().getProcessHandler());
            this.waitForCompleted();
            DebuggerTestCase.assertNull((Object)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(this.getDebugProcess().getProcessHandler()));
            this.myDebuggerSession = null;
        }
        if (this.getChecker().contains("JVMTI_ERROR_WRONG_PHASE(112)")) {
            this.myRestart.incrementAndGet();
            if (this.needsRestart()) {
                return;
            }
        } else {
            this.myRestart.set(0);
        }
        this.throwExceptionsIfAny();
        this.checkTestOutput();
    }

    private boolean needsRestart() {
        int restart = this.myRestart.get();
        return restart > 0 && restart <= 3;
    }

    @Override
    protected void runBareRunnable(ThrowableRunnable<Throwable> runnable) throws Throwable {
        this.myTestRootDisposable = new UsefulTestCase.TestDisposable((UsefulTestCase)this);
        super.runBareRunnable(runnable);
        while (this.needsRestart()) {
            assert (this.myTestRootDisposable.isDisposed());
            this.myTestRootDisposable = new UsefulTestCase.TestDisposable((UsefulTestCase)this);
            super.runBareRunnable(runnable);
        }
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        UsefulTestCase.TestDisposable testDisposable = this.myTestRootDisposable;
        if (testDisposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/DebuggerTestCase", "getTestRootDisposable"));
        }
        return testDisposable;
    }

    protected void checkTestOutput() throws Exception {
        this.getChecker().checkValid(this.getTestProjectJdk());
    }

    protected void disposeSession(final DebuggerSession debuggerSession) throws InterruptedException, InvocationTargetException {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                debuggerSession.dispose();
            }
        });
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            FileEditorManagerEx.getInstanceEx((Project)this.getProject()).closeAllFiles();
            if (this.myDebugProcess != null) {
                this.myDebugProcess.stop(true);
                this.myDebugProcess.waitFor();
            }
            this.myTearDownRunnables.forEach(Runnable::run);
            this.myTearDownRunnables.clear();
        }
        finally {
            super.tearDown();
        }
    }

    protected void createLocalProcess(String className) throws ExecutionException, InterruptedException, InvocationTargetException {
        LOG.assertTrue(this.myDebugProcess == null);
        this.myDebuggerSession = this.createLocalProcess(0, this.createJavaParameters(className));
        this.myDebugProcess = this.myDebuggerSession.getProcess();
    }

    protected DebuggerSession createLocalSession(final JavaParameters javaParameters) throws ExecutionException, InterruptedException {
        this.createBreakpoints(javaParameters.getMainClass());
        DebuggerSettings.getInstance().DEBUGGER_TRANSPORT = 0;
        GenericDebuggerRunnerSettings debuggerRunnerSettings = new GenericDebuggerRunnerSettings();
        debuggerRunnerSettings.LOCAL = true;
        RemoteConnection debugParameters = DebuggerManagerImpl.createDebugParameters((JavaParameters)javaParameters, (GenericDebuggerRunnerSettings)debuggerRunnerSettings, (boolean)false);
        ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runnerSettings((RunnerSettings)debuggerRunnerSettings).runProfile(new MockConfiguration()).build();
        JavaCommandLineState javaCommandLineState = new JavaCommandLineState(environment){

            @Override
            protected JavaParameters createJavaParameters() {
                return javaParameters;
            }

            @Override
            protected GeneralCommandLine createCommandLine() throws ExecutionException {
                return this.getJavaParameters().toCommandLine();
            }
        };
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                this.myDebuggerSession = DebuggerManagerEx.getInstanceEx((Project)this.myProject).attachVirtualMachine((DebugEnvironment)new DefaultDebugEnvironment(new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runProfile(new MockConfiguration()).build(), (RunProfileState)javaCommandLineState, debugParameters, false));
                XDebuggerManager.getInstance(this.myProject).startSession(javaCommandLineState.getEnvironment(), new XDebugProcessStarter(){

                    @Override
                    @NotNull
                    public XDebugProcess start(@NotNull XDebugSession session) {
                        if (session == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/DebuggerTestCase$3", "start"));
                        }
                        JavaDebugProcess javaDebugProcess = JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)DebuggerTestCase.this.myDebuggerSession);
                        if (javaDebugProcess == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/DebuggerTestCase$3", "start"));
                        }
                        return javaDebugProcess;
                    }
                });
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        });
        this.myDebugProcess = this.myDebuggerSession.getProcess();
        this.myDebugProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                DebuggerTestCase.this.print(event.getText(), outputType);
            }
        });
        DebuggerTestCase.assertNotNull((Object)this.myDebuggerSession);
        DebuggerTestCase.assertNotNull((Object)this.myDebugProcess);
        return this.myDebuggerSession;
    }

    protected DebuggerSession createLocalProcess(int transport, final JavaParameters javaParameters) throws ExecutionException, InterruptedException, InvocationTargetException {
        this.createBreakpoints(javaParameters.getMainClass());
        final DebuggerSession[] debuggerSession = new DebuggerSession[]{null};
        DebuggerSettings.getInstance().DEBUGGER_TRANSPORT = transport;
        GenericDebuggerRunnerSettings debuggerRunnerSettings = new GenericDebuggerRunnerSettings();
        debuggerRunnerSettings.LOCAL = true;
        debuggerRunnerSettings.setDebugPort(String.valueOf(3456));
        ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runnerSettings((RunnerSettings)debuggerRunnerSettings).runProfile(new MockConfiguration()).build();
        final JavaCommandLineState javaCommandLineState = new JavaCommandLineState(environment){

            @Override
            protected JavaParameters createJavaParameters() {
                return javaParameters;
            }

            @Override
            protected GeneralCommandLine createCommandLine() throws ExecutionException {
                return this.getJavaParameters().toCommandLine();
            }
        };
        final RemoteConnection debugParameters = DebuggerManagerImpl.createDebugParameters((JavaParameters)javaCommandLineState.getJavaParameters(), (GenericDebuggerRunnerSettings)debuggerRunnerSettings, (boolean)true);
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    debuggerSession[0] = DebuggerTestCase.this.attachVirtualMachine(javaCommandLineState, javaCommandLineState.getEnvironment(), debugParameters, false);
                }
                catch (ExecutionException e) {
                    TestCase.fail((String)e.getMessage());
                }
            }
        });
        ProcessHandler processHandler = debuggerSession[0].getProcess().getProcessHandler();
        debuggerSession[0].getProcess().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                DebuggerTestCase.this.print(event.getText(), outputType);
            }
        });
        DebugProcessImpl process = (DebugProcessImpl)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(processHandler);
        DebuggerTestCase.assertNotNull((Object)process);
        return debuggerSession[0];
    }

    protected DebuggerSession createRemoteProcess(int transport, boolean serverMode, JavaParameters javaParameters) throws ExecutionException, InterruptedException, InvocationTargetException {
        DebuggerSession debuggerSession;
        boolean useSockets = transport == 0;
        RemoteConnection remoteConnection = new RemoteConnection(useSockets, "127.0.0.1", String.valueOf(3456), serverMode);
        String launchCommandLine = remoteConnection.getLaunchCommandLine();
        launchCommandLine = StringUtil.replace((String)launchCommandLine, (String)",onthrow=<FQ exception class name>", (String)"");
        launchCommandLine = StringUtil.replace((String)launchCommandLine, (String)",onuncaught=<y/n>", (String)"");
        launchCommandLine = StringUtil.replace((String)launchCommandLine, (String)"suspend=n", (String)"suspend=y");
        this.println(launchCommandLine, ProcessOutputTypes.SYSTEM);
        StringTokenizer tokenizer = new StringTokenizer(launchCommandLine);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            javaParameters.getVMParametersList().add(token);
        }
        GeneralCommandLine commandLine = javaParameters.toCommandLine();
        if (serverMode) {
            debuggerSession = this.attachVM(remoteConnection, false);
            commandLine.createProcess();
        } else {
            commandLine.createProcess();
            debuggerSession = this.attachVM(remoteConnection, true);
        }
        ProcessHandler processHandler = debuggerSession.getProcess().getProcessHandler();
        DebugProcessImpl process = (DebugProcessImpl)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(processHandler);
        DebuggerTestCase.assertNotNull((Object)process);
        return debuggerSession;
    }

    protected DebuggerSession attachVM(RemoteConnection remoteConnection, boolean pollConnection) throws InvocationTargetException, InterruptedException {
        RemoteStateState remoteState = new RemoteStateState(this.myProject, remoteConnection);
        final DebuggerSession[] debuggerSession = new DebuggerSession[1];
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable((RemoteState)remoteState, remoteConnection, pollConnection){
            final /* synthetic */ RemoteState val$remoteState;
            final /* synthetic */ RemoteConnection val$remoteConnection;
            final /* synthetic */ boolean val$pollConnection;
            {
                this.val$remoteState = remoteState;
                this.val$remoteConnection = remoteConnection;
                this.val$pollConnection = bl;
            }

            @Override
            public void run() {
                try {
                    debuggerSession[0] = DebuggerTestCase.this.attachVirtualMachine(this.val$remoteState, new ExecutionEnvironmentBuilder(DebuggerTestCase.this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runProfile(new MockConfiguration()).build(), this.val$remoteConnection, this.val$pollConnection);
                }
                catch (ExecutionException e) {
                    TestCase.fail((String)e.getMessage());
                }
            }
        });
        debuggerSession[0].getProcess().getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                DebuggerTestCase.this.print(event.getText(), outputType);
            }
        });
        return debuggerSession[0];
    }

    protected void createBreakpoints(final String className) {
        PsiFile psiFile = ApplicationManager.getApplication().runReadAction(new Computable<PsiFile>(){

            public PsiFile compute() {
                PsiClass psiClass = JavaPsiFacade.getInstance(DebuggerTestCase.this.myProject).findClass(className, GlobalSearchScope.allScope(DebuggerTestCase.this.myProject));
                TestCase.assertNotNull((Object)psiClass);
                return psiClass.getContainingFile();
            }
        });
        this.createBreakpoints(psiFile);
    }

    protected EvaluationContextImpl createEvaluationContext(SuspendContextImpl suspendContext) {
        try {
            StackFrameProxyImpl proxy = suspendContext.getFrameProxy();
            DebuggerTestCase.assertNotNull((Object)proxy);
            return new EvaluationContextImpl(suspendContext, proxy, (Value)proxy.thisObject());
        }
        catch (EvaluateException e) {
            this.error(e);
            return null;
        }
    }

    protected void waitForCompleted() {
        final SynchronizationBasedSemaphore s = new SynchronizationBasedSemaphore();
        s.down();
        final InvokeThread.WorkerThreadRequest request = this.getDebugProcess().getManagerThread().getCurrentRequest();
        Thread thread = new Thread("Joining " + request){

            @Override
            public void run() {
                try {
                    request.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
        if (request.isDone()) {
            thread.interrupt();
        }
        this.waitFor(() -> {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.invokeRatherLater(new DebuggerCommandImpl(){

            protected void action() throws Exception {
                LOG.assertTrue(false);
            }

            protected void commandCancelled() {
                DebuggerTestCase.this.invokeRatherLater(new DebuggerCommandImpl(){

                    protected void action() throws Exception {
                        LOG.assertTrue(false);
                    }

                    protected void commandCancelled() {
                        s.up();
                    }
                });
            }
        });
        this.waitFor(() -> s.waitFor());
    }

    public DebuggerContextImpl createDebuggerContext(final SuspendContextImpl suspendContext, StackFrameProxyImpl stackFrame) {
        final DebuggerSession[] session = new DebuggerSession[1];
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                session[0] = DebuggerManagerEx.getInstanceEx((Project)DebuggerTestCase.this.myProject).getSession((DebugProcess)suspendContext.getDebugProcess());
            }
        });
        DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext((DebuggerSession)session[0], (SuspendContextImpl)suspendContext, (ThreadReferenceProxyImpl)(stackFrame != null ? stackFrame.threadProxy() : null), (StackFrameProxyImpl)stackFrame);
        debuggerContext.initCaches();
        return debuggerContext;
    }

    public DebuggerContextImpl createDebuggerContext(SuspendContextImpl suspendContext) {
        return this.createDebuggerContext(suspendContext, suspendContext.getFrameProxy());
    }

    protected void printLocation(SuspendContextImpl suspendContext) {
        try {
            Location location = suspendContext.getFrameProxy().location();
            String message = "paused at " + location.sourceName() + ":" + location.lineNumber();
            this.println(message, ProcessOutputTypes.SYSTEM);
        }
        catch (Throwable e) {
            this.addException(e);
        }
    }

    protected void createBreakpointInHelloWorld() {
        DebuggerInvocationUtil.invokeAndWait((Project)this.myProject, () -> {
            BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)this.myProject).getBreakpointManager();
            PsiClass psiClass = JavaPsiFacade.getInstance(this.myProject).findClass("HelloWorld", GlobalSearchScope.allScope(this.myProject));
            DebuggerTestCase.assertNotNull((Object)psiClass);
            Document document = PsiDocumentManager.getInstance(this.myProject).getDocument(psiClass.getContainingFile());
            breakpointManager.addLineBreakpoint(document, 3);
        }, (ModalityState)ApplicationManager.getApplication().getDefaultModalityState());
    }

    protected void createHelloWorldProcessWithBreakpoint() throws ExecutionException, InterruptedException, InvocationTargetException {
        this.createLocalProcess("HelloWorld");
        this.createBreakpointInHelloWorld();
    }

    @Override
    protected DebugProcessImpl getDebugProcess() {
        return this.myDebuggerSession != null ? this.myDebuggerSession.getProcess() : null;
    }

    public DebuggerSession getDebuggerSession() {
        return this.myDebuggerSession;
    }

    protected DebuggerSession attachVirtualMachine(RunProfileState state, ExecutionEnvironment environment, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx((Project)this.myProject).attachVirtualMachine((DebugEnvironment)new DefaultDebugEnvironment(environment, state, remoteConnection, pollConnection));
        XDebuggerManager.getInstance(this.myProject).startSession(environment, new XDebugProcessStarter(){

            @Override
            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/DebuggerTestCase$14", "start"));
                }
                JavaDebugProcess javaDebugProcess = JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)debuggerSession);
                if (javaDebugProcess == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/DebuggerTestCase$14", "start"));
                }
                return javaDebugProcess;
            }
        });
        return debuggerSession;
    }

    protected void disableRenderer(NodeRenderer renderer) {
        this.setRendererEnabled(renderer, false);
    }

    protected void enableRenderer(NodeRenderer renderer) {
        this.setRendererEnabled(renderer, true);
    }

    private void setRendererEnabled(NodeRenderer renderer, boolean state) {
        boolean oldValue = renderer.isEnabled();
        if (oldValue != state) {
            this.myTearDownRunnables.add(() -> renderer.setEnabled(oldValue));
            renderer.setEnabled(state);
        }
    }

    protected void doWhenXSessionPausedThenResume(final ThrowableRunnable runnable) {
        final XDebugSession session = this.getDebuggerSession().getXDebugSession();
        DebuggerTestCase.assertNotNull((Object)session);
        session.addSessionListener(new XDebugSessionListener(){

            @Override
            public void sessionPaused() {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        runnable.run();
                    }
                    catch (Throwable e) {
                        DebuggerTestCase.this.addException(e);
                    }
                    finally {
                        SwingUtilities.invokeLater(session::resume);
                    }
                });
            }
        });
    }

    public class MockConfiguration
    implements ModuleRunConfiguration {
        @Override
        @NotNull
        public Module[] getModules() {
            if (DebuggerTestCase.this.myModule != null) {
                Module[] moduleArray = new Module[]{DebuggerTestCase.this.myModule};
                if (moduleArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/DebuggerTestCase$MockConfiguration", "getModules"));
                }
                return moduleArray;
            }
            if (Module.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/DebuggerTestCase$MockConfiguration", "getModules"));
            }
            return Module.EMPTY_ARRAY;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public ConfigurationFactory getFactory() {
            return null;
        }

        @Override
        public void setName(String name) {
        }

        @Override
        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Project getProject() {
            return null;
        }

        @Override
        @NotNull
        public ConfigurationType getType() {
            UnknownConfigurationType unknownConfigurationType = UnknownConfigurationType.INSTANCE;
            if (unknownConfigurationType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/DebuggerTestCase$MockConfiguration", "getType"));
            }
            return unknownConfigurationType;
        }

        @Override
        public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
            return null;
        }

        @Override
        public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
            return null;
        }

        @Override
        public RunConfiguration clone() {
            return null;
        }

        @Override
        public int getUniqueID() {
            return 0;
        }

        @Override
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/debugger/DebuggerTestCase$MockConfiguration", "getState"));
            }
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/debugger/DebuggerTestCase$MockConfiguration", "getState"));
            }
            return null;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public void checkConfiguration() throws RuntimeConfigurationException {
        }

        public void readExternal(Element element) throws InvalidDataException {
        }

        public void writeExternal(Element element) throws WriteExternalException {
        }
    }
}

