/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiActivity
implements ComparableObject {
    private final List<String> myElements;

    public UiActivity(String ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/UiActivity", "<init>"));
        }
        this(elements, (String[])null);
    }

    protected UiActivity(@NotNull String[] elements1, @Nullable String[] elements2) {
        if (elements1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements1", "com/intellij/ide/UiActivity", "<init>"));
        }
        this.myElements = new ArrayList<String>();
        this.myElements.addAll(Arrays.asList(elements1));
        if (elements2 != null) {
            this.myElements.addAll(Arrays.asList(elements2));
        }
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myElements};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivity", "getEqualityObjects"));
        }
        return objectArray;
    }

    public String toString() {
        return "UiActivity: " + this.myElements;
    }

    public int hashCode() {
        return ComparableObjectCheck.hashCode((ComparableObject)this, (int)super.hashCode());
    }

    public boolean equals(Object obj) {
        return ComparableObjectCheck.equals((ComparableObject)this, (Object)obj);
    }

    public final boolean isSameOrGeneralFor(UiActivity other) {
        if (this.myElements.size() > other.myElements.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.myElements.size(); ++i2) {
            if (this.myElements.get(i2).equals(other.myElements.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static class Progress
    extends UiActivity {
        public Progress(String type, String id) {
            super("progress", type, id);
        }

        public static class Modal
        extends Progress {
            public Modal(String id) {
                super("modal", id);
            }
        }
    }

    public static class AsyncBgOperation
    extends UiActivity {
        public AsyncBgOperation(String operationName) {
            super("asyncBgOperation", operationName);
        }
    }

    public static class Focus
    extends UiActivity {
        public Focus(String ... subOperation) {
            super(new String[]{"focus"}, subOperation);
        }
    }
}

