/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.util.importProject.RootDetectionProcessor;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.EmptyIcon;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ImportFromSourcesTestCase
extends PlatformTestCase {
    private ProjectFromSourcesBuilderImpl myBuilder;
    private File myRootDir;

    public void setUp() throws Exception {
        super.setUp();
        this.myBuilder = new ProjectFromSourcesBuilderImpl(new WizardContext(null), ModulesProvider.EMPTY_MODULES_PROVIDER);
    }

    protected void setUpProject() throws Exception {
    }

    protected Module assertOneModule(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/ide/projectWizard/ImportFromSourcesTestCase", "assertOneModule"));
        }
        Module module = (Module)ImportFromSourcesTestCase.assertOneElement((Object[])ModuleManager.getInstance(this.myProject).getModules());
        ImportFromSourcesTestCase.assertEquals((Object)moduleType, (Object)ModuleType.get(module));
        return module;
    }

    protected void assertOneContentRoot(@NotNull Module module, String relativePath) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/projectWizard/ImportFromSourcesTestCase", "assertOneContentRoot"));
        }
        File expected = new File(this.myRootDir, relativePath);
        String url = (String)ImportFromSourcesTestCase.assertOneElement((Object[])ModuleRootManager.getInstance(module).getContentRootUrls());
        File actual = new File(VfsUtilCore.urlToPath(url));
        ImportFromSourcesTestCase.assertEquals((String)expected.getAbsolutePath(), (String)actual.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importFromSources(File dir) {
        this.myRootDir = dir;
        try {
            this.myProject = this.doCreateProject(this.getIprFile());
            this.myBuilder.setBaseProjectPath(dir.getAbsolutePath());
            List list = RootDetectionProcessor.detectRoots((File)dir);
            MultiMap map = RootDetectionProcessor.createRootsMap((List)list);
            this.myBuilder.setupProjectStructure(map);
            for (ProjectStructureDetector detector : map.keySet()) {
                List steps = detector.createWizardSteps((ProjectFromSourcesBuilder)this.myBuilder, this.myBuilder.getProjectDescriptor(detector), EmptyIcon.ICON_16);
                try {
                    for (ModuleWizardStep step : steps) {
                        if (!(step instanceof AbstractStepWithProgress)) continue;
                        ImportFromSourcesTestCase.performStep((AbstractStepWithProgress)step);
                    }
                }
                finally {
                    for (ModuleWizardStep step : steps) {
                        step.disposeUIResources();
                    }
                }
            }
            this.myBuilder.commit(this.myProject, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <Result> void performStep(AbstractStepWithProgress<Result> step) {
        step.performStep();
    }
}

