/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageFilter;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeLanguage
extends Language {
    private final List<LanguageFilter> myFilters = ContainerUtil.createLockFreeCopyOnWriteList();

    protected CompositeLanguage(String id) {
        super(id);
    }

    protected CompositeLanguage(String ID, String ... mimeTypes) {
        super(ID, mimeTypes);
    }

    protected CompositeLanguage(Language baseLanguage, String ID, String ... mimeTypes) {
        super(baseLanguage, ID, mimeTypes);
    }

    public void registerLanguageExtension(LanguageFilter filter) {
        if (!this.myFilters.contains(filter)) {
            this.myFilters.add(filter);
        }
    }

    public boolean unregisterLanguageExtension(LanguageFilter filter) {
        return this.myFilters.remove(filter);
    }

    public Language[] getLanguageExtensionsForFile(PsiFile psi) {
        ArrayList<Language> extensions = new ArrayList<Language>(1);
        for (LanguageFilter filter : this.myFilters) {
            if (!filter.isRelevantForFile(psi)) continue;
            extensions.add(filter.getLanguage());
        }
        return extensions.toArray(new Language[extensions.size()]);
    }

    @NotNull
    public LanguageFilter[] getLanguageExtensions() {
        LanguageFilter[] languageFilterArray = (LanguageFilter[])ArrayUtil.stripTrailingNulls((Object[])this.myFilters.toArray(new LanguageFilter[this.myFilters.size()]));
        if (languageFilterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/CompositeLanguage", "getLanguageExtensions"));
        }
        return languageFilterArray;
    }
}

