/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeEditorHighlighterProviders
extends FileTypeExtension<EditorHighlighterProvider> {
    public static final FileTypeEditorHighlighterProviders INSTANCE = new FileTypeEditorHighlighterProviders();

    private FileTypeEditorHighlighterProviders() {
        super("com.intellij.editorHighlighterProvider");
    }

    @Override
    @NotNull
    protected List<EditorHighlighterProvider> buildExtensions(@NotNull String stringKey, @NotNull FileType key) {
        if (stringKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringKey", "com/intellij/openapi/fileTypes/FileTypeEditorHighlighterProviders", "buildExtensions"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/fileTypes/FileTypeEditorHighlighterProviders", "buildExtensions"));
        }
        List<EditorHighlighterProvider> fromEP = super.buildExtensions(stringKey, key);
        if (fromEP.isEmpty()) {
            EditorHighlighterProvider defaultProvider = new EditorHighlighterProvider(){

                @Override
                public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile2, @NotNull EditorColorsScheme colors) {
                    if (fileType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/FileTypeEditorHighlighterProviders$1", "getEditorHighlighter"));
                    }
                    if (colors == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/openapi/fileTypes/FileTypeEditorHighlighterProviders$1", "getEditorHighlighter"));
                    }
                    return EditorHighlighterFactory.getInstance().createEditorHighlighter(SyntaxHighlighterFactory.getSyntaxHighlighter(fileType, project, virtualFile2), colors);
                }
            };
            List<EditorHighlighterProvider> list = Collections.singletonList(defaultProvider);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/FileTypeEditorHighlighterProviders", "buildExtensions"));
            }
            return list;
        }
        List<EditorHighlighterProvider> list = fromEP;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/FileTypeEditorHighlighterProviders", "buildExtensions"));
        }
        return list;
    }
}

