/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BeanConfigurable<T>
implements UnnamedConfigurable {
    private final T myInstance;
    private final List<BeanField> myFields;

    protected BeanConfigurable(@NotNull T beanInstance) {
        if (beanInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanInstance", "com/intellij/openapi/options/BeanConfigurable", "<init>"));
        }
        this.myFields = new ArrayList<BeanField>();
        this.myInstance = beanInstance;
    }

    @NotNull
    protected T getInstance() {
        T t = this.myInstance;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/BeanConfigurable", "getInstance"));
        }
        return t;
    }

    protected void checkBox(@NonNls String fieldName, String title) {
        this.myFields.add(new CheckboxField(fieldName, title));
    }

    protected void checkBox(@NotNull String title, final @NotNull Getter<Boolean> getter, final @NotNull Setter<Boolean> setter) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/options/BeanConfigurable", "checkBox"));
        }
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/openapi/options/BeanConfigurable", "checkBox"));
        }
        if (setter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setter", "com/intellij/openapi/options/BeanConfigurable", "checkBox"));
        }
        CheckboxField field = new CheckboxField("", title){

            @Override
            Object getBeanValue(@NotNull Object instance) {
                if (instance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/options/BeanConfigurable$1", "getBeanValue"));
                }
                return getter.get();
            }

            @Override
            void setBeanValue(Object instance, Object value) {
                setter.set((Object)((Boolean)value));
            }
        };
        this.myFields.add(field);
    }

    protected <V> void component(final @NotNull JComponent component, final @NotNull Getter<V> beanGetter, final @NotNull Setter<V> beanSetter, final @NotNull Getter<V> componentGetter, final @NotNull Setter<V> componentSetter) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/options/BeanConfigurable", "component"));
        }
        if (beanGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanGetter", "com/intellij/openapi/options/BeanConfigurable", "component"));
        }
        if (beanSetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanSetter", "com/intellij/openapi/options/BeanConfigurable", "component"));
        }
        if (componentGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentGetter", "com/intellij/openapi/options/BeanConfigurable", "component"));
        }
        if (componentSetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentSetter", "com/intellij/openapi/options/BeanConfigurable", "component"));
        }
        BeanField<JComponent> field = new BeanField<JComponent>(""){

            @Override
            @NotNull
            JComponent createComponent() {
                JComponent jComponent = component;
                if (jComponent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/BeanConfigurable$2", "createComponent"));
                }
                return jComponent;
            }

            @Override
            Object getComponentValue() {
                return componentGetter.get();
            }

            @Override
            void setComponentValue(Object value) {
                componentSetter.set(value);
            }

            @Override
            protected Class getValueClass() {
                return null;
            }

            @Override
            Object getBeanValue(@NotNull Object instance) {
                if (instance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/options/BeanConfigurable$2", "getBeanValue"));
                }
                return beanGetter.get();
            }

            @Override
            void setBeanValue(Object instance, Object value) {
                beanSetter.set(value);
            }
        };
        this.myFields.add(field);
    }

    @Override
    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridLayout(this.myFields.size(), 1));
        for (BeanField field : this.myFields) {
            panel.add((Component)field.getComponent());
        }
        return panel;
    }

    @Override
    public boolean isModified() {
        for (BeanField field : this.myFields) {
            if (!field.isModified(this.myInstance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply() throws ConfigurationException {
        for (BeanField field : this.myFields) {
            field.apply(this.myInstance);
        }
    }

    @Override
    public void reset() {
        for (BeanField field : this.myFields) {
            field.reset(this.myInstance);
        }
    }

    private static class CheckboxField
    extends BeanField<JCheckBox> {
        private final String myTitle;

        private CheckboxField(String fieldName, String title) {
            super(fieldName);
            this.myTitle = title;
        }

        @Override
        @NotNull
        JCheckBox createComponent() {
            JCheckBox jCheckBox = new JCheckBox(this.myTitle);
            if (jCheckBox == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/BeanConfigurable$CheckboxField", "createComponent"));
            }
            return jCheckBox;
        }

        @Override
        Object getComponentValue() {
            return ((JCheckBox)this.getComponent()).isSelected();
        }

        @Override
        void setComponentValue(Object value) {
            ((JCheckBox)this.getComponent()).setSelected((Boolean)value);
        }

        @Override
        protected String getterName() {
            return "is" + StringUtil.capitalize((String)this.myFieldName);
        }

        @Override
        protected Class getValueClass() {
            return Boolean.TYPE;
        }
    }

    private static abstract class BeanField<T extends JComponent> {
        String myFieldName;
        T myComponent;

        private BeanField(String fieldName) {
            this.myFieldName = fieldName;
        }

        T getComponent() {
            if (this.myComponent == null) {
                this.myComponent = this.createComponent();
            }
            return this.myComponent;
        }

        @NotNull
        abstract T createComponent();

        boolean isModified(@NotNull Object instance) {
            Object beanValue;
            if (instance == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/options/BeanConfigurable$BeanField", "isModified"));
            }
            Object componentValue = this.getComponentValue();
            return !Comparing.equal((Object)componentValue, (Object)(beanValue = this.getBeanValue(instance)));
        }

        void apply(@NotNull Object instance) {
            if (instance == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/options/BeanConfigurable$BeanField", "apply"));
            }
            this.setBeanValue(instance, this.getComponentValue());
        }

        void reset(@NotNull Object instance) {
            if (instance == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/options/BeanConfigurable$BeanField", "reset"));
            }
            this.setComponentValue(this.getBeanValue(instance));
        }

        abstract Object getComponentValue();

        abstract void setComponentValue(Object var1);

        Object getBeanValue(@NotNull Object instance) {
            if (instance == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/options/BeanConfigurable$BeanField", "getBeanValue"));
            }
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                return field.get(instance);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = instance.getClass().getMethod(this.getterName(), new Class[0]);
                    return method.invoke(instance, new Object[0]);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @NonNls
        protected String getterName() {
            return "get" + StringUtil.capitalize((String)this.myFieldName);
        }

        void setBeanValue(Object instance, Object value) {
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                field.set(instance, value);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = instance.getClass().getMethod("set" + StringUtil.capitalize((String)this.myFieldName), this.getValueClass());
                    method.invoke(instance, value);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract Class getValueClass();
    }
}

