/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.CompositeSettingsBuilder;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.util.Alarm;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class CompositeSettingsEditor<Settings>
extends SettingsEditor<Settings> {
    public static final Logger LOG = Logger.getInstance(CompositeSettingsEditor.class);
    private Collection<SettingsEditor<Settings>> myEditors;
    private SettingsEditorListener<Settings> myChildSettingsListener;
    private SynchronizationController mySyncController;
    private boolean myIsDisposed = false;

    public CompositeSettingsEditor() {
    }

    public CompositeSettingsEditor(Factory<Settings> factory) {
        super(factory);
        if (factory != null) {
            this.mySyncController = new SynchronizationController();
        }
    }

    public abstract CompositeSettingsBuilder<Settings> getBuilder();

    @Override
    public void resetEditorFrom(@NotNull Settings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/options/CompositeSettingsEditor", "resetEditorFrom"));
        }
        for (SettingsEditor<Settings> myEditor : this.myEditors) {
            try {
                myEditor.resetEditorFrom(settings);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void applyEditorTo(@NotNull Settings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/options/CompositeSettingsEditor", "applyEditorTo"));
        }
        for (SettingsEditor<Settings> myEditor : this.myEditors) {
            try {
                myEditor.applyTo(settings);
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void uninstallWatcher() {
        for (SettingsEditor<Settings> editor : this.myEditors) {
            editor.removeSettingsEditorListener(this.myChildSettingsListener);
        }
    }

    @Override
    public void installWatcher(JComponent c) {
        this.myChildSettingsListener = new SettingsEditorListener<Settings>(){

            @Override
            public void stateChanged(SettingsEditor<Settings> editor) {
                CompositeSettingsEditor.this.fireEditorStateChanged();
                if (CompositeSettingsEditor.this.mySyncController != null) {
                    CompositeSettingsEditor.this.mySyncController.handleStateChange(editor);
                }
            }
        };
        for (SettingsEditor<Settings> editor : this.myEditors) {
            editor.addSettingsEditorListener(this.myChildSettingsListener);
        }
    }

    @Override
    @NotNull
    protected final JComponent createEditor() {
        CompositeSettingsBuilder<Settings> builder = this.getBuilder();
        this.myEditors = builder.getEditors();
        for (SettingsEditor<Settings> editor : this.myEditors) {
            Disposer.register((Disposable)this, editor);
            editor.setOwner(this);
        }
        JComponent jComponent = builder.createCompoundEditor();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/CompositeSettingsEditor", "createEditor"));
        }
        return jComponent;
    }

    @Override
    public void disposeEditor() {
        this.myIsDisposed = true;
    }

    private class SynchronizationController {
        private final Set<SettingsEditor> myChangedEditors = new HashSet<SettingsEditor>();
        private final Alarm mySyncAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private boolean myIsInSync = false;

        private SynchronizationController() {
        }

        public void handleStateChange(SettingsEditor editor) {
            if (this.myIsInSync || CompositeSettingsEditor.this.myIsDisposed) {
                return;
            }
            this.myChangedEditors.add(editor);
            this.mySyncAlarm.cancelAllRequests();
            this.mySyncAlarm.addRequest(() -> {
                if (!CompositeSettingsEditor.this.myIsDisposed) {
                    this.sync();
                }
            }, 300);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sync() {
            this.myIsInSync = true;
            try {
                Object snapshot = CompositeSettingsEditor.this.getSnapshot();
                for (SettingsEditor editor : CompositeSettingsEditor.this.myEditors) {
                    if (this.myChangedEditors.contains(editor)) continue;
                    editor.resetFrom(snapshot);
                }
            }
            catch (ConfigurationException configurationException) {
            }
            finally {
                this.myChangedEditors.clear();
                this.myIsInSync = false;
            }
        }
    }
}

