/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ComboBoxWithWidePopup<E>
extends JComboBox<E> {
    private boolean myLayingOut;
    private int myMinLength = 20;

    public ComboBoxWithWidePopup() {
    }

    public ComboBoxWithWidePopup(ComboBoxModel<E> aModel) {
        super(aModel);
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            this.setMaximumRowCount(25);
        }
    }

    public ComboBoxWithWidePopup(E[] items) {
        super(items);
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            this.setMaximumRowCount(25);
        }
    }

    @Override
    public void setRenderer(ListCellRenderer<? super E> renderer) {
        super.setRenderer(new AdjustingListCellRenderer(this, renderer));
    }

    public void setMinLength(int minLength) {
        this.myMinLength = minLength;
    }

    protected int getMinLength() {
        return this.myMinLength;
    }

    @Override
    public void doLayout() {
        try {
            this.myLayingOut = true;
            super.doLayout();
        }
        finally {
            this.myLayingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension size = super.getSize();
        if (!this.myLayingOut) {
            size.width = Math.max(size.width, this.getOriginalPreferredSize().width);
        }
        return size;
    }

    private Dimension _getSuperSize() {
        return super.getSize();
    }

    protected Dimension getOriginalPreferredSize() {
        return this.getPreferredSize();
    }

    private class AdjustingListCellRenderer
    implements ListCellRenderer<E> {
        private final ListCellRenderer<? super E> myOldRenderer;
        private final ComboBoxWithWidePopup myComboBox;

        public AdjustingListCellRenderer(ComboBoxWithWidePopup<E> comboBox, ListCellRenderer<? super E> oldRenderer) {
            this.myComboBox = comboBox;
            this.myOldRenderer = oldRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
            Object _value = value;
            if (index == -1 && _value instanceof String && !this.myComboBox.isValid()) {
                int minLength = ComboBoxWithWidePopup.this.getMinLength();
                Dimension size = this.myComboBox._getSuperSize();
                String stringValue = (String)_value;
                if (size.width == 0 && stringValue.length() > minLength) {
                    String e = stringValue.substring(0, minLength);
                    _value = e;
                }
            }
            return this.myOldRenderer.getListCellRendererComponent(list, (Object)_value, index, isSelected, cellHasFocus);
        }
    }
}

