/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import org.jetbrains.annotations.NotNull;

public abstract class LightCodeInsightTestCase
extends LightPlatformCodeInsightTestCase {
    public static JavaPsiFacadeEx getJavaFacade() {
        return JavaPsiFacadeEx.getInstanceEx((Project)ourProject);
    }

    protected void setUp() throws Exception {
        super.setUp();
        LightCodeInsightTestCase.setLanguageLevel(this.getLanguageLevel());
    }

    protected LanguageLevel getLanguageLevel() {
        return LanguageLevel.HIGHEST;
    }

    protected static void setLanguageLevel(LanguageLevel level) {
        LanguageLevelProjectExtension.getInstance(LightCodeInsightTestCase.getProject()).setLanguageLevel(level);
    }

    protected Sdk getProjectJDK() {
        return IdeaTestUtil.getMockJdk18();
    }

    @NotNull
    protected ModuleType getModuleType() {
        ModuleType moduleType = StdModuleTypes.JAVA;
        if (moduleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightCodeInsightTestCase", "getModuleType"));
        }
        return moduleType;
    }
}

