/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class GuiUtils {
    private static final Insets paddingFromDialogBoundaries = new Insets(7, 5, 7, 5);
    private static final Insets paddingInsideDialog = new Insets(5, 5, 5, 5);
    private static final CharFilter NOT_MNEMONIC_CHAR_FILTER = new CharFilter(){

        public boolean accept(char ch) {
            return ch != '&' && ch != '\u001b';
        }
    };

    public static JPanel constructFieldWithBrowseButton(JComponent aComponent, ActionListener aActionListener) {
        return GuiUtils.constructFieldWithBrowseButton(aComponent, aActionListener, 0);
    }

    public static JPanel constructFieldWithBrowseButton(TextFieldWithHistory aComponent, ActionListener aActionListener) {
        return GuiUtils.constructFieldWithBrowseButton(aComponent, aActionListener, 0);
    }

    private static JPanel constructFieldWithBrowseButton(JComponent aComponent, ActionListener aActionListener, int delta) {
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)aComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        FixedSizeButton browseButton = new FixedSizeButton(aComponent.getPreferredSize().height - delta);
        ComponentWithBrowseButton.MyDoClickAction.addTo(browseButton, aComponent);
        result.add((Component)browseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        browseButton.addActionListener(aActionListener);
        return result;
    }

    public static JPanel constructDirectoryBrowserField(final JTextField field, final String objectName) {
        return GuiUtils.constructFieldWithBrowseButton(field, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle("Select " + objectName);
                VirtualFile file = FileChooser.chooseFile(descriptor, field, null, null);
                if (file != null) {
                    field.setText(FileUtil.toSystemDependentName((String)file.getPath()));
                    field.postActionEvent();
                }
            }
        });
    }

    public static JPanel constructFileURLBrowserField(final TextFieldWithHistory field, final String objectName) {
        return GuiUtils.constructFieldWithBrowseButton(field, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle("Select " + objectName);
                VirtualFile file = FileChooser.chooseFile(descriptor, field, null, null);
                if (file != null) {
                    try {
                        field.setText(VfsUtilCore.virtualToIoFile(file).toURI().toURL().toString());
                    }
                    catch (MalformedURLException e1) {
                        field.setText("");
                    }
                }
            }
        });
    }

    public static JComponent constructLabeledComponent(String aLabelText, JComponent aComponent, @JdkConstants.BoxLayoutAxis int aAxis) {
        JPanel result = new JPanel();
        BoxLayout boxLayout = new BoxLayout(result, aAxis);
        result.setLayout(boxLayout);
        result.add(new JLabel(aLabelText));
        result.add(aComponent);
        return result;
    }

    public static JPanel makeDialogPanel(JPanel aPanel) {
        JPanel emptyBordered = GuiUtils.makePaddedPanel(aPanel, paddingFromDialogBoundaries);
        return GuiUtils.wrapWithBorder(emptyBordered, IdeBorderFactory.createRoundedBorder());
    }

    public static JPanel makeTitledPanel(JComponent aComponent, String aTitle) {
        JPanel result = GuiUtils.makePaddedPanel(aComponent, false, true, false, true);
        return GuiUtils.wrapWithBorder(result, IdeBorderFactory.createTitledBorder(aTitle, true));
    }

    private static JPanel wrapWithBorder(JComponent aPanel, Border aBorder) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)aPanel, "Center");
        wrapper.setBorder(aBorder);
        return wrapper;
    }

    public static BorderLayout createBorderLayout() {
        return new BorderLayout(GuiUtils.paddingInsideDialog.left, GuiUtils.paddingInsideDialog.top);
    }

    public static GridLayout createGridLayout(int aRows, int aColumns) {
        return new GridLayout(aRows, aColumns, GuiUtils.paddingInsideDialog.left, GuiUtils.paddingInsideDialog.top);
    }

    public static Component createVerticalStrut() {
        return Box.createRigidArea(new Dimension(0, GuiUtils.paddingInsideDialog.top));
    }

    public static Component createHorisontalStrut() {
        return Box.createRigidArea(new Dimension(GuiUtils.paddingInsideDialog.left, 0));
    }

    private static JPanel makePaddedPanel(JComponent aComponent, Insets aInsets) {
        return GuiUtils.wrapWithBorder(aComponent, BorderFactory.createEmptyBorder(aInsets.top, aInsets.left, aInsets.bottom, aInsets.right));
    }

    private static JPanel makePaddedPanel(JComponent aComponent, boolean aTop, boolean aLeft, boolean aBottom, boolean aRight) {
        return GuiUtils.wrapWithBorder(aComponent, BorderFactory.createEmptyBorder(aTop ? GuiUtils.paddingInsideDialog.top : 0, aLeft ? GuiUtils.paddingInsideDialog.left : 0, aBottom ? GuiUtils.paddingInsideDialog.bottom : 0, aRight ? GuiUtils.paddingInsideDialog.right : 0));
    }

    public static void setAdditionalIcon(JRadioButton button, Icon icon) {
        Icon defaultIcon = UIUtil.getRadioButtonIcon();
        LayeredIcon deficon = new LayeredIcon(2);
        deficon.setIcon(defaultIcon, 0);
        deficon.setIcon(icon, 1, defaultIcon.getIconWidth() + JBUI.scale((int)5), 0);
        button.setIcon((Icon)((Object)deficon));
        LayeredIcon pressed = new LayeredIcon(2);
        pressed.setIcon(defaultIcon, 0);
        pressed.setIcon(icon, 1, defaultIcon.getIconWidth() + JBUI.scale((int)5), 0);
        button.setPressedIcon((Icon)((Object)pressed));
        LayeredIcon selected = new LayeredIcon(2);
        selected.setIcon(defaultIcon, 0);
        selected.setIcon(icon, 1, defaultIcon.getIconWidth() + JBUI.scale((int)5), 0);
        button.setSelectedIcon((Icon)((Object)selected));
    }

    public static String getTextWithoutMnemonicEscaping(String text) {
        return StringUtil.strip((String)text, (CharFilter)NOT_MNEMONIC_CHAR_FILTER);
    }

    public static char getDisplayedMnemonic(String text) {
        int i2 = GuiUtils.getDisplayedMnemonicIndex(text);
        return i2 == -1 ? (char)'\uffff' : text.charAt(i2 + 1);
    }

    public static int getDisplayedMnemonicIndex(String text) {
        return text.indexOf("&");
    }

    public static void packParentDialog(Component component) {
        while (component != null) {
            if (component instanceof JDialog) {
                component.setVisible(true);
                break;
            }
            component = component.getParent();
        }
    }

    public static void replaceJSplitPaneWithIDEASplitter(JComponent root) {
        Container parent = root.getParent();
        if (root instanceof JSplitPane) {
            if (parent.getComponents().length != 1 && !(parent instanceof Splitter)) {
                return;
            }
            JSplitPane pane = (JSplitPane)root;
            Component component1 = pane.getTopComponent();
            Component component2 = pane.getBottomComponent();
            int orientation = pane.getOrientation();
            JBSplitter splitter = new JBSplitter(orientation == 0);
            splitter.setFirstComponent((JComponent)component1);
            splitter.setSecondComponent((JComponent)component2);
            splitter.setShowDividerControls(pane.isOneTouchExpandable());
            splitter.setHonorComponentsMinimumSize(true);
            if (pane.getDividerLocation() > 0) {
                SwingUtilities.invokeLater(() -> {
                    double proportion = pane.getOrientation() == 0 ? (double)pane.getDividerLocation() / (double)(parent.getHeight() - pane.getDividerSize()) : (double)pane.getDividerLocation() / (double)(parent.getWidth() - pane.getDividerSize());
                    if (proportion > 0.0 && proportion < 1.0) {
                        splitter.setProportion((float)proportion);
                    }
                });
            }
            if (parent instanceof Splitter) {
                Splitter psplitter = (Splitter)parent;
                if (psplitter.getFirstComponent() == root) {
                    psplitter.setFirstComponent((JComponent)((Object)splitter));
                } else {
                    psplitter.setSecondComponent((JComponent)((Object)splitter));
                }
            } else {
                parent.remove(0);
                parent.setLayout(new BorderLayout());
                parent.add((Component)((Object)splitter), "Center");
            }
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component1);
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component2);
        } else {
            Component[] components;
            for (Component component : components = root.getComponents()) {
                if (!(component instanceof JComponent)) continue;
                GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component);
            }
        }
    }

    public static void iterateChildren(Component container, Consumer<Component> consumer, JComponent ... excludeComponents) {
        if (excludeComponents != null && ArrayUtil.find((Object[])excludeComponents, (Object)container) != -1) {
            return;
        }
        consumer.consume((Object)container);
        if (container instanceof Container) {
            Component[] components;
            for (Component child : components = ((Container)container).getComponents()) {
                GuiUtils.iterateChildren(child, consumer, excludeComponents);
            }
        }
    }

    public static void iterateChildren(Consumer<Component> consumer, Component ... components) {
        for (Component component : components) {
            GuiUtils.iterateChildren(component, consumer, new JComponent[0]);
        }
    }

    public static void enableChildren(boolean enabled, Component ... components) {
        for (Component component : components) {
            GuiUtils.enableChildren(component, enabled, new JComponent[0]);
        }
    }

    public static void showComponents(boolean visible, Component ... components) {
        for (Component component : components) {
            component.setVisible(visible);
        }
    }

    public static void enableChildren(Component container, boolean enabled, JComponent ... excludeComponents) {
        GuiUtils.iterateChildren(container, (Consumer<Component>)((Consumer)t -> GuiUtils.enableComponent(t, enabled)), excludeComponents);
    }

    private static void enableComponent(Component component, boolean enabled) {
        if (component.isEnabled() == enabled) {
            return;
        }
        component.setEnabled(enabled);
        if (component instanceof JPanel) {
            Border border = ((JPanel)component).getBorder();
            if (border instanceof TitledBorder) {
                Color color = enabled ? component.getForeground() : UIUtil.getInactiveTextColor();
                ((TitledBorder)border).setTitleColor(color);
            }
        } else if (component instanceof JLabel) {
            Color color = UIUtil.getInactiveTextColor();
            if (color == null) {
                color = component.getForeground();
            }
            String changeColorString = "<font color=#" + GuiUtils.colorToHex(color) + ">";
            JLabel label = (JLabel)component;
            String text = label.getText();
            if (text != null && text.startsWith("<html>")) {
                if (StringUtil.startsWithConcatenation((String)text, (String[])new String[]{"<html>", changeColorString}) && enabled) {
                    text = "<html>" + text.substring(("<html>" + changeColorString).length());
                } else if (!StringUtil.startsWithConcatenation((String)text, (String[])new String[]{"<html>", changeColorString}) && !enabled) {
                    text = "<html>" + changeColorString + text.substring("<html>".length());
                }
                label.setText(text);
            }
        } else if (component instanceof JTable) {
            TableColumnModel columnModel = ((JTable)component).getColumnModel();
            for (int i2 = 0; i2 < columnModel.getColumnCount(); ++i2) {
                TableCellRenderer cellRenderer = columnModel.getColumn(0).getCellRenderer();
                if (!(cellRenderer instanceof Component)) continue;
                GuiUtils.enableComponent((Component)((Object)cellRenderer), enabled);
            }
        }
    }

    public static String colorToHex(Color color) {
        return GuiUtils.to2DigitsHex(color.getRed()) + GuiUtils.to2DigitsHex(color.getGreen()) + GuiUtils.to2DigitsHex(color.getBlue());
    }

    private static String to2DigitsHex(int i2) {
        String s = Integer.toHexString(i2);
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    public static void runOrInvokeAndWait(@NotNull Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ui/GuiUtils", "runOrInvokeAndWait"));
        }
        ApplicationManager.getApplication().invokeAndWait(runnable);
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ui/GuiUtils", "invokeLaterIfNeeded"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/ui/GuiUtils", "invokeLaterIfNeeded"));
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, modalityState);
        }
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable, @NotNull ModalityState modalityState, @NotNull Condition expired) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ui/GuiUtils", "invokeLaterIfNeeded"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/ui/GuiUtils", "invokeLaterIfNeeded"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/ui/GuiUtils", "invokeLaterIfNeeded"));
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, modalityState, expired);
        }
    }

    public static JTextField createUndoableTextField() {
        return new JBTextField();
    }

    @NotNull
    public static Dimension getSizeByChars(int charCount, @NotNull JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/ui/GuiUtils", "getSizeByChars"));
        }
        Dimension size = comp.getPreferredSize();
        FontMetrics fontMetrics = comp.getFontMetrics(comp.getFont());
        size.width = fontMetrics.charWidth('a') * charCount;
        Dimension dimension = size;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/GuiUtils", "getSizeByChars"));
        }
        return dimension;
    }
}

