/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content;

import com.intellij.ui.content.Content;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;

public class ContentManagerEvent
extends EventObject {
    @NotNull
    private final Content myContent;
    private final int myIndex;
    private boolean myConsumed;
    private final ContentOperation myOperation;

    public ContentManagerEvent(Object source, @NotNull Content content, int index, ContentOperation operation) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/ContentManagerEvent", "<init>"));
        }
        super(source);
        this.myContent = content;
        this.myIndex = index;
        this.myOperation = operation;
    }

    public ContentManagerEvent(Object source, @NotNull Content content, int index) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/ContentManagerEvent", "<init>"));
        }
        this(source, content, index, ContentOperation.undefined);
    }

    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/ContentManagerEvent", "getContent"));
        }
        return content;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public boolean isConsumed() {
        return this.myConsumed;
    }

    public void consume() {
        this.myConsumed = true;
    }

    public ContentOperation getOperation() {
        return this.myOperation;
    }

    public static enum ContentOperation {
        add,
        remove,
        undefined;

    }
}

