/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.MappingClass;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassMappingNameConverter
extends ResolvingConverter.StringConverter {
    private static final Logger LOG = Logger.getInstance(ClassMappingNameConverter.class);

    @Override
    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        PsiType type;
        DomElement parent = context.getInvocationElement().getParent();
        assert (parent != null);
        List<DomElement> children = DomUtil.getDefinedChildren(parent, true, true);
        DomElement classElement = (DomElement)ContainerUtil.find(children, domElement -> domElement.getAnnotation(MappingClass.class) != null);
        if (classElement == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ClassMappingNameConverter", "getVariants"));
            }
            return list;
        }
        Object value = ((GenericDomValue)classElement).getValue();
        if (value == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ClassMappingNameConverter", "getVariants"));
            }
            return list;
        }
        if (value instanceof PsiType) {
            type = (PsiType)value;
        } else if (value instanceof PsiClass) {
            type = PsiTypesUtil.getClassType((PsiClass)value);
        } else {
            LOG.error("wrong type: " + value.getClass());
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ClassMappingNameConverter", "getVariants"));
            }
            return list;
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(context.getProject());
        SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, type);
        List<String> list = Arrays.asList(info.names);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ClassMappingNameConverter", "getVariants"));
        }
        return list;
    }

    @Override
    public PsiElement resolve(String o, ConvertContext context) {
        DomElement parent = context.getInvocationElement().getParent();
        assert (parent != null);
        return parent.getXmlElement();
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element, String stringValue, @Nullable String resolveResult, ConvertContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/ClassMappingNameConverter", "isReferenceTo"));
        }
        return element.getManager().areElementsEquivalent(element, this.resolve(stringValue, context));
    }
}

