/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;

public abstract class XSourcePositionWrapper
implements XSourcePosition {
    protected final XSourcePosition myPosition;

    protected XSourcePositionWrapper(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/XSourcePositionWrapper", "<init>"));
        }
        this.myPosition = position;
    }

    @Override
    public final int getLine() {
        return this.myPosition.getLine();
    }

    @Override
    public final int getOffset() {
        return this.myPosition.getOffset();
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myPosition.getFile();
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/XSourcePositionWrapper", "getFile"));
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/XSourcePositionWrapper", "createNavigatable"));
        }
        Navigatable navigatable = this.myPosition.createNavigatable(project);
        if (navigatable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/XSourcePositionWrapper", "createNavigatable"));
        }
        return navigatable;
    }
}

